package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StreamingNotificationTarget(
    notificationTarget: Optional[
      zio.aws.chimesdkvoice.model.NotificationTarget
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.StreamingNotificationTarget = {
    import StreamingNotificationTarget.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.StreamingNotificationTarget
      .builder()
      .optionallyWith(notificationTarget.map(value => value.unwrap))(
        _.notificationTarget
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.StreamingNotificationTarget.ReadOnly =
    zio.aws.chimesdkvoice.model.StreamingNotificationTarget
      .wrap(buildAwsValue())
}
object StreamingNotificationTarget {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.StreamingNotificationTarget
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.StreamingNotificationTarget =
      zio.aws.chimesdkvoice.model
        .StreamingNotificationTarget(notificationTarget.map(value => value))
    def notificationTarget
        : Optional[zio.aws.chimesdkvoice.model.NotificationTarget]
    def getNotificationTarget
        : ZIO[Any, AwsError, zio.aws.chimesdkvoice.model.NotificationTarget] =
      AwsError.unwrapOptionField("notificationTarget", notificationTarget)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.StreamingNotificationTarget
  ) extends zio.aws.chimesdkvoice.model.StreamingNotificationTarget.ReadOnly {
    override val notificationTarget
        : Optional[zio.aws.chimesdkvoice.model.NotificationTarget] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notificationTarget())
        .map(value =>
          zio.aws.chimesdkvoice.model.NotificationTarget.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.StreamingNotificationTarget
  ): zio.aws.chimesdkvoice.model.StreamingNotificationTarget.ReadOnly =
    new Wrapper(impl)
}
