package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkvoice.model.primitives.NonEmptyString256
import scala.jdk.CollectionConverters._
final case class SpeakerSearchDetails(
    results: Optional[
      Iterable[zio.aws.chimesdkvoice.model.SpeakerSearchResult]
    ] = Optional.Absent,
    voiceprintGenerationStatus: Optional[NonEmptyString256] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.SpeakerSearchDetails = {
    import SpeakerSearchDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.SpeakerSearchDetails
      .builder()
      .optionallyWith(
        results.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.results)
      .optionallyWith(
        voiceprintGenerationStatus.map(value =>
          NonEmptyString256.unwrap(value): java.lang.String
        )
      )(_.voiceprintGenerationStatus)
      .build()
  }
  def asReadOnly: zio.aws.chimesdkvoice.model.SpeakerSearchDetails.ReadOnly =
    zio.aws.chimesdkvoice.model.SpeakerSearchDetails.wrap(buildAwsValue())
}
object SpeakerSearchDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.SpeakerSearchDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.SpeakerSearchDetails =
      zio.aws.chimesdkvoice.model.SpeakerSearchDetails(
        results.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        voiceprintGenerationStatus.map(value => value)
      )
    def results: Optional[
      List[zio.aws.chimesdkvoice.model.SpeakerSearchResult.ReadOnly]
    ]
    def voiceprintGenerationStatus: Optional[NonEmptyString256]
    def getResults: ZIO[Any, AwsError, List[
      zio.aws.chimesdkvoice.model.SpeakerSearchResult.ReadOnly
    ]] = AwsError.unwrapOptionField("results", results)
    def getVoiceprintGenerationStatus: ZIO[Any, AwsError, NonEmptyString256] =
      AwsError.unwrapOptionField(
        "voiceprintGenerationStatus",
        voiceprintGenerationStatus
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.SpeakerSearchDetails
  ) extends zio.aws.chimesdkvoice.model.SpeakerSearchDetails.ReadOnly {
    override val results: Optional[
      List[zio.aws.chimesdkvoice.model.SpeakerSearchResult.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.results())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.chimesdkvoice.model.SpeakerSearchResult.wrap(item)
        }.toList
      )
    override val voiceprintGenerationStatus: Optional[NonEmptyString256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.voiceprintGenerationStatus())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.NonEmptyString256(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.SpeakerSearchDetails
  ): zio.aws.chimesdkvoice.model.SpeakerSearchDetails.ReadOnly = new Wrapper(
    impl
  )
}
