package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkvoice.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters._
final case class PutVoiceConnectorLoggingConfigurationRequest(
    voiceConnectorId: NonEmptyString,
    loggingConfiguration: zio.aws.chimesdkvoice.model.LoggingConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorLoggingConfigurationRequest = {
    import PutVoiceConnectorLoggingConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorLoggingConfigurationRequest
      .builder()
      .voiceConnectorId(
        NonEmptyString.unwrap(voiceConnectorId): java.lang.String
      )
      .loggingConfiguration(loggingConfiguration.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.PutVoiceConnectorLoggingConfigurationRequest.ReadOnly =
    zio.aws.chimesdkvoice.model.PutVoiceConnectorLoggingConfigurationRequest
      .wrap(buildAwsValue())
}
object PutVoiceConnectorLoggingConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorLoggingConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkvoice.model.PutVoiceConnectorLoggingConfigurationRequest =
      zio.aws.chimesdkvoice.model.PutVoiceConnectorLoggingConfigurationRequest(
        voiceConnectorId,
        loggingConfiguration.asEditable
      )
    def voiceConnectorId: NonEmptyString
    def loggingConfiguration
        : zio.aws.chimesdkvoice.model.LoggingConfiguration.ReadOnly
    def getVoiceConnectorId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(voiceConnectorId)
    def getLoggingConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.chimesdkvoice.model.LoggingConfiguration.ReadOnly
    ] = ZIO.succeed(loggingConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorLoggingConfigurationRequest
  ) extends zio.aws.chimesdkvoice.model.PutVoiceConnectorLoggingConfigurationRequest.ReadOnly {
    override val voiceConnectorId: NonEmptyString =
      zio.aws.chimesdkvoice.model.primitives
        .NonEmptyString(impl.voiceConnectorId())
    override val loggingConfiguration
        : zio.aws.chimesdkvoice.model.LoggingConfiguration.ReadOnly =
      zio.aws.chimesdkvoice.model.LoggingConfiguration
        .wrap(impl.loggingConfiguration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorLoggingConfigurationRequest
  ): zio.aws.chimesdkvoice.model.PutVoiceConnectorLoggingConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
