package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkvoice.model.primitives.{E164PhoneNumber, Integer}
import scala.jdk.CollectionConverters._
final case class Proxy(
    defaultSessionExpiryMinutes: Optional[Integer] = Optional.Absent,
    disabled: Optional[Boolean] = Optional.Absent,
    fallBackPhoneNumber: Optional[E164PhoneNumber] = Optional.Absent,
    phoneNumberCountries: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.Proxy = {
    import Proxy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.Proxy
      .builder()
      .optionallyWith(
        defaultSessionExpiryMinutes.map(value => value: java.lang.Integer)
      )(_.defaultSessionExpiryMinutes)
      .optionallyWith(disabled.map(value => value: java.lang.Boolean))(
        _.disabled
      )
      .optionallyWith(
        fallBackPhoneNumber.map(value =>
          E164PhoneNumber.unwrap(value): java.lang.String
        )
      )(_.fallBackPhoneNumber)
      .optionallyWith(
        phoneNumberCountries.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.phoneNumberCountries)
      .build()
  }
  def asReadOnly: zio.aws.chimesdkvoice.model.Proxy.ReadOnly =
    zio.aws.chimesdkvoice.model.Proxy.wrap(buildAwsValue())
}
object Proxy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.Proxy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.Proxy =
      zio.aws.chimesdkvoice.model.Proxy(
        defaultSessionExpiryMinutes.map(value => value),
        disabled.map(value => value),
        fallBackPhoneNumber.map(value => value),
        phoneNumberCountries.map(value => value)
      )
    def defaultSessionExpiryMinutes: Optional[Integer]
    def disabled: Optional[Boolean]
    def fallBackPhoneNumber: Optional[E164PhoneNumber]
    def phoneNumberCountries: Optional[List[String]]
    def getDefaultSessionExpiryMinutes: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "defaultSessionExpiryMinutes",
        defaultSessionExpiryMinutes
      )
    def getDisabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("disabled", disabled)
    def getFallBackPhoneNumber: ZIO[Any, AwsError, E164PhoneNumber] =
      AwsError.unwrapOptionField("fallBackPhoneNumber", fallBackPhoneNumber)
    def getPhoneNumberCountries: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("phoneNumberCountries", phoneNumberCountries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.Proxy
  ) extends zio.aws.chimesdkvoice.model.Proxy.ReadOnly {
    override val defaultSessionExpiryMinutes: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultSessionExpiryMinutes())
        .map(value => value: Integer)
    override val disabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.disabled())
      .map(value => value: Boolean)
    override val fallBackPhoneNumber: Optional[E164PhoneNumber] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fallBackPhoneNumber())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.E164PhoneNumber(value)
        )
    override val phoneNumberCountries: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.phoneNumberCountries())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.Proxy
  ): zio.aws.chimesdkvoice.model.Proxy.ReadOnly = new Wrapper(impl)
}
