package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkvoice.model.primitives.Alpha2CountryCode
import scala.jdk.CollectionConverters._
final case class PhoneNumberCountry(
    countryCode: Optional[Alpha2CountryCode] = Optional.Absent,
    supportedPhoneNumberTypes: Optional[
      Iterable[zio.aws.chimesdkvoice.model.PhoneNumberType]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.PhoneNumberCountry = {
    import PhoneNumberCountry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.PhoneNumberCountry
      .builder()
      .optionallyWith(
        countryCode.map(value =>
          Alpha2CountryCode.unwrap(value): java.lang.String
        )
      )(_.countryCode)
      .optionallyWith(
        supportedPhoneNumberTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.supportedPhoneNumberTypesWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.chimesdkvoice.model.PhoneNumberCountry.ReadOnly =
    zio.aws.chimesdkvoice.model.PhoneNumberCountry.wrap(buildAwsValue())
}
object PhoneNumberCountry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.PhoneNumberCountry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.PhoneNumberCountry =
      zio.aws.chimesdkvoice.model.PhoneNumberCountry(
        countryCode.map(value => value),
        supportedPhoneNumberTypes.map(value => value)
      )
    def countryCode: Optional[Alpha2CountryCode]
    def supportedPhoneNumberTypes
        : Optional[List[zio.aws.chimesdkvoice.model.PhoneNumberType]]
    def getCountryCode: ZIO[Any, AwsError, Alpha2CountryCode] =
      AwsError.unwrapOptionField("countryCode", countryCode)
    def getSupportedPhoneNumberTypes: ZIO[Any, AwsError, List[
      zio.aws.chimesdkvoice.model.PhoneNumberType
    ]] = AwsError.unwrapOptionField(
      "supportedPhoneNumberTypes",
      supportedPhoneNumberTypes
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.PhoneNumberCountry
  ) extends zio.aws.chimesdkvoice.model.PhoneNumberCountry.ReadOnly {
    override val countryCode: Optional[Alpha2CountryCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.countryCode())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.Alpha2CountryCode(value)
        )
    override val supportedPhoneNumberTypes
        : Optional[List[zio.aws.chimesdkvoice.model.PhoneNumberType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportedPhoneNumberTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chimesdkvoice.model.PhoneNumberType.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.PhoneNumberCountry
  ): zio.aws.chimesdkvoice.model.PhoneNumberCountry.ReadOnly = new Wrapper(impl)
}
