package zio.aws.chimesdkvoice.model
import zio.aws.chimesdkvoice.model.primitives.{
  SensitiveNonEmptyString,
  Alpha2CountryCode,
  GuidString,
  CallingName,
  E164PhoneNumber,
  Iso8601Timestamp
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class PhoneNumber(
    phoneNumberId: Optional[SensitiveNonEmptyString] = Optional.Absent,
    e164PhoneNumber: Optional[E164PhoneNumber] = Optional.Absent,
    country: Optional[Alpha2CountryCode] = Optional.Absent,
    `type`: Optional[zio.aws.chimesdkvoice.model.PhoneNumberType] =
      Optional.Absent,
    productType: Optional[zio.aws.chimesdkvoice.model.PhoneNumberProductType] =
      Optional.Absent,
    status: Optional[zio.aws.chimesdkvoice.model.PhoneNumberStatus] =
      Optional.Absent,
    capabilities: Optional[
      zio.aws.chimesdkvoice.model.PhoneNumberCapabilities
    ] = Optional.Absent,
    associations: Optional[
      Iterable[zio.aws.chimesdkvoice.model.PhoneNumberAssociation]
    ] = Optional.Absent,
    callingName: Optional[CallingName] = Optional.Absent,
    callingNameStatus: Optional[zio.aws.chimesdkvoice.model.CallingNameStatus] =
      Optional.Absent,
    createdTimestamp: Optional[Iso8601Timestamp] = Optional.Absent,
    updatedTimestamp: Optional[Iso8601Timestamp] = Optional.Absent,
    deletionTimestamp: Optional[Iso8601Timestamp] = Optional.Absent,
    orderId: Optional[GuidString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.PhoneNumber = {
    import PhoneNumber.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.PhoneNumber
      .builder()
      .optionallyWith(
        phoneNumberId.map(value =>
          SensitiveNonEmptyString.unwrap(value): java.lang.String
        )
      )(_.phoneNumberId)
      .optionallyWith(
        e164PhoneNumber.map(value =>
          E164PhoneNumber.unwrap(value): java.lang.String
        )
      )(_.e164PhoneNumber)
      .optionallyWith(
        country.map(value => Alpha2CountryCode.unwrap(value): java.lang.String)
      )(_.country)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(productType.map(value => value.unwrap))(_.productType)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(capabilities.map(value => value.buildAwsValue()))(
        _.capabilities
      )
      .optionallyWith(
        associations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.associations)
      .optionallyWith(
        callingName.map(value => CallingName.unwrap(value): java.lang.String)
      )(_.callingName)
      .optionallyWith(callingNameStatus.map(value => value.unwrap))(
        _.callingNameStatus
      )
      .optionallyWith(
        createdTimestamp.map(value => Iso8601Timestamp.unwrap(value): Instant)
      )(_.createdTimestamp)
      .optionallyWith(
        updatedTimestamp.map(value => Iso8601Timestamp.unwrap(value): Instant)
      )(_.updatedTimestamp)
      .optionallyWith(
        deletionTimestamp.map(value => Iso8601Timestamp.unwrap(value): Instant)
      )(_.deletionTimestamp)
      .optionallyWith(
        orderId.map(value => GuidString.unwrap(value): java.lang.String)
      )(_.orderId)
      .build()
  }
  def asReadOnly: zio.aws.chimesdkvoice.model.PhoneNumber.ReadOnly =
    zio.aws.chimesdkvoice.model.PhoneNumber.wrap(buildAwsValue())
}
object PhoneNumber {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.PhoneNumber
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.PhoneNumber =
      zio.aws.chimesdkvoice.model.PhoneNumber(
        phoneNumberId.map(value => value),
        e164PhoneNumber.map(value => value),
        country.map(value => value),
        `type`.map(value => value),
        productType.map(value => value),
        status.map(value => value),
        capabilities.map(value => value.asEditable),
        associations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        callingName.map(value => value),
        callingNameStatus.map(value => value),
        createdTimestamp.map(value => value),
        updatedTimestamp.map(value => value),
        deletionTimestamp.map(value => value),
        orderId.map(value => value)
      )
    def phoneNumberId: Optional[SensitiveNonEmptyString]
    def e164PhoneNumber: Optional[E164PhoneNumber]
    def country: Optional[Alpha2CountryCode]
    def `type`: Optional[zio.aws.chimesdkvoice.model.PhoneNumberType]
    def productType
        : Optional[zio.aws.chimesdkvoice.model.PhoneNumberProductType]
    def status: Optional[zio.aws.chimesdkvoice.model.PhoneNumberStatus]
    def capabilities
        : Optional[zio.aws.chimesdkvoice.model.PhoneNumberCapabilities.ReadOnly]
    def associations: Optional[
      List[zio.aws.chimesdkvoice.model.PhoneNumberAssociation.ReadOnly]
    ]
    def callingName: Optional[CallingName]
    def callingNameStatus
        : Optional[zio.aws.chimesdkvoice.model.CallingNameStatus]
    def createdTimestamp: Optional[Iso8601Timestamp]
    def updatedTimestamp: Optional[Iso8601Timestamp]
    def deletionTimestamp: Optional[Iso8601Timestamp]
    def orderId: Optional[GuidString]
    def getPhoneNumberId: ZIO[Any, AwsError, SensitiveNonEmptyString] =
      AwsError.unwrapOptionField("phoneNumberId", phoneNumberId)
    def getE164PhoneNumber: ZIO[Any, AwsError, E164PhoneNumber] =
      AwsError.unwrapOptionField("e164PhoneNumber", e164PhoneNumber)
    def getCountry: ZIO[Any, AwsError, Alpha2CountryCode] =
      AwsError.unwrapOptionField("country", country)
    def getType
        : ZIO[Any, AwsError, zio.aws.chimesdkvoice.model.PhoneNumberType] =
      AwsError.unwrapOptionField("type", `type`)
    def getProductType: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkvoice.model.PhoneNumberProductType
    ] = AwsError.unwrapOptionField("productType", productType)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.chimesdkvoice.model.PhoneNumberStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCapabilities: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkvoice.model.PhoneNumberCapabilities.ReadOnly
    ] = AwsError.unwrapOptionField("capabilities", capabilities)
    def getAssociations: ZIO[Any, AwsError, List[
      zio.aws.chimesdkvoice.model.PhoneNumberAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField("associations", associations)
    def getCallingName: ZIO[Any, AwsError, CallingName] =
      AwsError.unwrapOptionField("callingName", callingName)
    def getCallingNameStatus
        : ZIO[Any, AwsError, zio.aws.chimesdkvoice.model.CallingNameStatus] =
      AwsError.unwrapOptionField("callingNameStatus", callingNameStatus)
    def getCreatedTimestamp: ZIO[Any, AwsError, Iso8601Timestamp] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
    def getUpdatedTimestamp: ZIO[Any, AwsError, Iso8601Timestamp] =
      AwsError.unwrapOptionField("updatedTimestamp", updatedTimestamp)
    def getDeletionTimestamp: ZIO[Any, AwsError, Iso8601Timestamp] =
      AwsError.unwrapOptionField("deletionTimestamp", deletionTimestamp)
    def getOrderId: ZIO[Any, AwsError, GuidString] =
      AwsError.unwrapOptionField("orderId", orderId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.PhoneNumber
  ) extends zio.aws.chimesdkvoice.model.PhoneNumber.ReadOnly {
    override val phoneNumberId: Optional[SensitiveNonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.phoneNumberId())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.SensitiveNonEmptyString(value)
        )
    override val e164PhoneNumber: Optional[E164PhoneNumber] =
      zio.aws.core.internal
        .optionalFromNullable(impl.e164PhoneNumber())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.E164PhoneNumber(value)
        )
    override val country: Optional[Alpha2CountryCode] = zio.aws.core.internal
      .optionalFromNullable(impl.country())
      .map(value =>
        zio.aws.chimesdkvoice.model.primitives.Alpha2CountryCode(value)
      )
    override val `type`: Optional[zio.aws.chimesdkvoice.model.PhoneNumberType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.chimesdkvoice.model.PhoneNumberType.wrap(value))
    override val productType
        : Optional[zio.aws.chimesdkvoice.model.PhoneNumberProductType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.productType())
        .map(value =>
          zio.aws.chimesdkvoice.model.PhoneNumberProductType.wrap(value)
        )
    override val status
        : Optional[zio.aws.chimesdkvoice.model.PhoneNumberStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.chimesdkvoice.model.PhoneNumberStatus.wrap(value))
    override val capabilities: Optional[
      zio.aws.chimesdkvoice.model.PhoneNumberCapabilities.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.capabilities())
      .map(value =>
        zio.aws.chimesdkvoice.model.PhoneNumberCapabilities.wrap(value)
      )
    override val associations: Optional[
      List[zio.aws.chimesdkvoice.model.PhoneNumberAssociation.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.associations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.chimesdkvoice.model.PhoneNumberAssociation.wrap(item)
        }.toList
      )
    override val callingName: Optional[CallingName] = zio.aws.core.internal
      .optionalFromNullable(impl.callingName())
      .map(value => zio.aws.chimesdkvoice.model.primitives.CallingName(value))
    override val callingNameStatus
        : Optional[zio.aws.chimesdkvoice.model.CallingNameStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.callingNameStatus())
        .map(value => zio.aws.chimesdkvoice.model.CallingNameStatus.wrap(value))
    override val createdTimestamp: Optional[Iso8601Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdTimestamp())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.Iso8601Timestamp(value)
        )
    override val updatedTimestamp: Optional[Iso8601Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updatedTimestamp())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.Iso8601Timestamp(value)
        )
    override val deletionTimestamp: Optional[Iso8601Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deletionTimestamp())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.Iso8601Timestamp(value)
        )
    override val orderId: Optional[GuidString] = zio.aws.core.internal
      .optionalFromNullable(impl.orderId())
      .map(value => zio.aws.chimesdkvoice.model.primitives.GuidString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.PhoneNumber
  ): zio.aws.chimesdkvoice.model.PhoneNumber.ReadOnly = new Wrapper(impl)
}
