package zio.aws.chimesdkvoice.model
import zio.aws.chimesdkvoice.model.primitives.{ResultMax, NonEmptyString256}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListVoiceProfilesRequest(
    voiceProfileDomainId: NonEmptyString256,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[ResultMax] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceProfilesRequest = {
    import ListVoiceProfilesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceProfilesRequest
      .builder()
      .voiceProfileDomainId(
        NonEmptyString256.unwrap(voiceProfileDomainId): java.lang.String
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => ResultMax.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.ListVoiceProfilesRequest.ReadOnly =
    zio.aws.chimesdkvoice.model.ListVoiceProfilesRequest.wrap(buildAwsValue())
}
object ListVoiceProfilesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceProfilesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.ListVoiceProfilesRequest =
      zio.aws.chimesdkvoice.model.ListVoiceProfilesRequest(
        voiceProfileDomainId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def voiceProfileDomainId: NonEmptyString256
    def nextToken: Optional[String]
    def maxResults: Optional[ResultMax]
    def getVoiceProfileDomainId: ZIO[Any, Nothing, NonEmptyString256] =
      ZIO.succeed(voiceProfileDomainId)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ResultMax] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceProfilesRequest
  ) extends zio.aws.chimesdkvoice.model.ListVoiceProfilesRequest.ReadOnly {
    override val voiceProfileDomainId: NonEmptyString256 =
      zio.aws.chimesdkvoice.model.primitives
        .NonEmptyString256(impl.voiceProfileDomainId())
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[ResultMax] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.chimesdkvoice.model.primitives.ResultMax(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceProfilesRequest
  ): zio.aws.chimesdkvoice.model.ListVoiceProfilesRequest.ReadOnly =
    new Wrapper(impl)
}
