package zio.aws.chimesdkvoice.model
import scala.jdk.CollectionConverters._
sealed trait LanguageCode {
  def unwrap: software.amazon.awssdk.services.chimesdkvoice.model.LanguageCode
}
object LanguageCode {
  def wrap(
      value: software.amazon.awssdk.services.chimesdkvoice.model.LanguageCode
  ): zio.aws.chimesdkvoice.model.LanguageCode = value match {
    case software.amazon.awssdk.services.chimesdkvoice.model.LanguageCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.chimesdkvoice.model.LanguageCode.EN_US =>
      val r = `en-US`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.chimesdkvoice.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkvoice.model.LanguageCode =
      software.amazon.awssdk.services.chimesdkvoice.model.LanguageCode.UNKNOWN_TO_SDK_VERSION
  }
  case object `en-US` extends zio.aws.chimesdkvoice.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkvoice.model.LanguageCode =
      software.amazon.awssdk.services.chimesdkvoice.model.LanguageCode.EN_US
  }
}
