package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetVoiceToneAnalysisTaskResponse(
    voiceToneAnalysisTask: Optional[
      zio.aws.chimesdkvoice.model.VoiceToneAnalysisTask
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceToneAnalysisTaskResponse = {
    import GetVoiceToneAnalysisTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceToneAnalysisTaskResponse
      .builder()
      .optionallyWith(
        voiceToneAnalysisTask.map(value => value.buildAwsValue())
      )(_.voiceToneAnalysisTask)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.GetVoiceToneAnalysisTaskResponse.ReadOnly =
    zio.aws.chimesdkvoice.model.GetVoiceToneAnalysisTaskResponse
      .wrap(buildAwsValue())
}
object GetVoiceToneAnalysisTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceToneAnalysisTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkvoice.model.GetVoiceToneAnalysisTaskResponse =
      zio.aws.chimesdkvoice.model.GetVoiceToneAnalysisTaskResponse(
        voiceToneAnalysisTask.map(value => value.asEditable)
      )
    def voiceToneAnalysisTask
        : Optional[zio.aws.chimesdkvoice.model.VoiceToneAnalysisTask.ReadOnly]
    def getVoiceToneAnalysisTask: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkvoice.model.VoiceToneAnalysisTask.ReadOnly
    ] =
      AwsError.unwrapOptionField("voiceToneAnalysisTask", voiceToneAnalysisTask)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceToneAnalysisTaskResponse
  ) extends zio.aws.chimesdkvoice.model.GetVoiceToneAnalysisTaskResponse.ReadOnly {
    override val voiceToneAnalysisTask
        : Optional[zio.aws.chimesdkvoice.model.VoiceToneAnalysisTask.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.voiceToneAnalysisTask())
        .map(value =>
          zio.aws.chimesdkvoice.model.VoiceToneAnalysisTask.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceToneAnalysisTaskResponse
  ): zio.aws.chimesdkvoice.model.GetVoiceToneAnalysisTaskResponse.ReadOnly =
    new Wrapper(impl)
}
