package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetVoiceProfileDomainResponse(
    voiceProfileDomain: Optional[
      zio.aws.chimesdkvoice.model.VoiceProfileDomain
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceProfileDomainResponse = {
    import GetVoiceProfileDomainResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceProfileDomainResponse
      .builder()
      .optionallyWith(voiceProfileDomain.map(value => value.buildAwsValue()))(
        _.voiceProfileDomain
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.GetVoiceProfileDomainResponse.ReadOnly =
    zio.aws.chimesdkvoice.model.GetVoiceProfileDomainResponse
      .wrap(buildAwsValue())
}
object GetVoiceProfileDomainResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceProfileDomainResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.GetVoiceProfileDomainResponse =
      zio.aws.chimesdkvoice.model.GetVoiceProfileDomainResponse(
        voiceProfileDomain.map(value => value.asEditable)
      )
    def voiceProfileDomain
        : Optional[zio.aws.chimesdkvoice.model.VoiceProfileDomain.ReadOnly]
    def getVoiceProfileDomain: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkvoice.model.VoiceProfileDomain.ReadOnly
    ] = AwsError.unwrapOptionField("voiceProfileDomain", voiceProfileDomain)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceProfileDomainResponse
  ) extends zio.aws.chimesdkvoice.model.GetVoiceProfileDomainResponse.ReadOnly {
    override val voiceProfileDomain
        : Optional[zio.aws.chimesdkvoice.model.VoiceProfileDomain.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.voiceProfileDomain())
        .map(value =>
          zio.aws.chimesdkvoice.model.VoiceProfileDomain.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceProfileDomainResponse
  ): zio.aws.chimesdkvoice.model.GetVoiceProfileDomainResponse.ReadOnly =
    new Wrapper(impl)
}
