package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetVoiceConnectorResponse(
    voiceConnector: Optional[zio.aws.chimesdkvoice.model.VoiceConnector] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorResponse = {
    import GetVoiceConnectorResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorResponse
      .builder()
      .optionallyWith(voiceConnector.map(value => value.buildAwsValue()))(
        _.voiceConnector
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.GetVoiceConnectorResponse.ReadOnly =
    zio.aws.chimesdkvoice.model.GetVoiceConnectorResponse.wrap(buildAwsValue())
}
object GetVoiceConnectorResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.GetVoiceConnectorResponse =
      zio.aws.chimesdkvoice.model.GetVoiceConnectorResponse(
        voiceConnector.map(value => value.asEditable)
      )
    def voiceConnector
        : Optional[zio.aws.chimesdkvoice.model.VoiceConnector.ReadOnly]
    def getVoiceConnector: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkvoice.model.VoiceConnector.ReadOnly
    ] = AwsError.unwrapOptionField("voiceConnector", voiceConnector)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorResponse
  ) extends zio.aws.chimesdkvoice.model.GetVoiceConnectorResponse.ReadOnly {
    override val voiceConnector
        : Optional[zio.aws.chimesdkvoice.model.VoiceConnector.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.voiceConnector())
        .map(value => zio.aws.chimesdkvoice.model.VoiceConnector.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorResponse
  ): zio.aws.chimesdkvoice.model.GetVoiceConnectorResponse.ReadOnly =
    new Wrapper(impl)
}
