package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkvoice.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters._
final case class GetVoiceConnectorGroupRequest(
    voiceConnectorGroupId: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorGroupRequest = {
    import GetVoiceConnectorGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorGroupRequest
      .builder()
      .voiceConnectorGroupId(
        NonEmptyString.unwrap(voiceConnectorGroupId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.GetVoiceConnectorGroupRequest.ReadOnly =
    zio.aws.chimesdkvoice.model.GetVoiceConnectorGroupRequest
      .wrap(buildAwsValue())
}
object GetVoiceConnectorGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.GetVoiceConnectorGroupRequest =
      zio.aws.chimesdkvoice.model
        .GetVoiceConnectorGroupRequest(voiceConnectorGroupId)
    def voiceConnectorGroupId: NonEmptyString
    def getVoiceConnectorGroupId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(voiceConnectorGroupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorGroupRequest
  ) extends zio.aws.chimesdkvoice.model.GetVoiceConnectorGroupRequest.ReadOnly {
    override val voiceConnectorGroupId: NonEmptyString =
      zio.aws.chimesdkvoice.model.primitives
        .NonEmptyString(impl.voiceConnectorGroupId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorGroupRequest
  ): zio.aws.chimesdkvoice.model.GetVoiceConnectorGroupRequest.ReadOnly =
    new Wrapper(impl)
}
