package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkvoice.model.primitives.{
  NonEmptyString256,
  NonEmptyString128
}
import scala.jdk.CollectionConverters._
final case class GetSpeakerSearchTaskRequest(
    voiceConnectorId: NonEmptyString128,
    speakerSearchTaskId: NonEmptyString256
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.GetSpeakerSearchTaskRequest = {
    import GetSpeakerSearchTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.GetSpeakerSearchTaskRequest
      .builder()
      .voiceConnectorId(
        NonEmptyString128.unwrap(voiceConnectorId): java.lang.String
      )
      .speakerSearchTaskId(
        NonEmptyString256.unwrap(speakerSearchTaskId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.GetSpeakerSearchTaskRequest.ReadOnly =
    zio.aws.chimesdkvoice.model.GetSpeakerSearchTaskRequest
      .wrap(buildAwsValue())
}
object GetSpeakerSearchTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.GetSpeakerSearchTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.GetSpeakerSearchTaskRequest =
      zio.aws.chimesdkvoice.model
        .GetSpeakerSearchTaskRequest(voiceConnectorId, speakerSearchTaskId)
    def voiceConnectorId: NonEmptyString128
    def speakerSearchTaskId: NonEmptyString256
    def getVoiceConnectorId: ZIO[Any, Nothing, NonEmptyString128] =
      ZIO.succeed(voiceConnectorId)
    def getSpeakerSearchTaskId: ZIO[Any, Nothing, NonEmptyString256] =
      ZIO.succeed(speakerSearchTaskId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.GetSpeakerSearchTaskRequest
  ) extends zio.aws.chimesdkvoice.model.GetSpeakerSearchTaskRequest.ReadOnly {
    override val voiceConnectorId: NonEmptyString128 =
      zio.aws.chimesdkvoice.model.primitives
        .NonEmptyString128(impl.voiceConnectorId())
    override val speakerSearchTaskId: NonEmptyString256 =
      zio.aws.chimesdkvoice.model.primitives
        .NonEmptyString256(impl.speakerSearchTaskId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.GetSpeakerSearchTaskRequest
  ): zio.aws.chimesdkvoice.model.GetSpeakerSearchTaskRequest.ReadOnly =
    new Wrapper(impl)
}
