package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetSipMediaApplicationResponse(
    sipMediaApplication: Optional[
      zio.aws.chimesdkvoice.model.SipMediaApplication
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.GetSipMediaApplicationResponse = {
    import GetSipMediaApplicationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.GetSipMediaApplicationResponse
      .builder()
      .optionallyWith(sipMediaApplication.map(value => value.buildAwsValue()))(
        _.sipMediaApplication
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.GetSipMediaApplicationResponse.ReadOnly =
    zio.aws.chimesdkvoice.model.GetSipMediaApplicationResponse
      .wrap(buildAwsValue())
}
object GetSipMediaApplicationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.GetSipMediaApplicationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.GetSipMediaApplicationResponse =
      zio.aws.chimesdkvoice.model.GetSipMediaApplicationResponse(
        sipMediaApplication.map(value => value.asEditable)
      )
    def sipMediaApplication
        : Optional[zio.aws.chimesdkvoice.model.SipMediaApplication.ReadOnly]
    def getSipMediaApplication: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkvoice.model.SipMediaApplication.ReadOnly
    ] = AwsError.unwrapOptionField("sipMediaApplication", sipMediaApplication)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.GetSipMediaApplicationResponse
  ) extends zio.aws.chimesdkvoice.model.GetSipMediaApplicationResponse.ReadOnly {
    override val sipMediaApplication
        : Optional[zio.aws.chimesdkvoice.model.SipMediaApplication.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sipMediaApplication())
        .map(value =>
          zio.aws.chimesdkvoice.model.SipMediaApplication.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.GetSipMediaApplicationResponse
  ): zio.aws.chimesdkvoice.model.GetSipMediaApplicationResponse.ReadOnly =
    new Wrapper(impl)
}
