package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkvoice.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters._
final case class GetSipMediaApplicationLoggingConfigurationRequest(
    sipMediaApplicationId: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.GetSipMediaApplicationLoggingConfigurationRequest = {
    import GetSipMediaApplicationLoggingConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.GetSipMediaApplicationLoggingConfigurationRequest
      .builder()
      .sipMediaApplicationId(
        NonEmptyString.unwrap(sipMediaApplicationId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.GetSipMediaApplicationLoggingConfigurationRequest.ReadOnly =
    zio.aws.chimesdkvoice.model.GetSipMediaApplicationLoggingConfigurationRequest
      .wrap(buildAwsValue())
}
object GetSipMediaApplicationLoggingConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.GetSipMediaApplicationLoggingConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkvoice.model.GetSipMediaApplicationLoggingConfigurationRequest =
      zio.aws.chimesdkvoice.model
        .GetSipMediaApplicationLoggingConfigurationRequest(
          sipMediaApplicationId
        )
    def sipMediaApplicationId: NonEmptyString
    def getSipMediaApplicationId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(sipMediaApplicationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.GetSipMediaApplicationLoggingConfigurationRequest
  ) extends zio.aws.chimesdkvoice.model.GetSipMediaApplicationLoggingConfigurationRequest.ReadOnly {
    override val sipMediaApplicationId: NonEmptyString =
      zio.aws.chimesdkvoice.model.primitives
        .NonEmptyString(impl.sipMediaApplicationId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.GetSipMediaApplicationLoggingConfigurationRequest
  ): zio.aws.chimesdkvoice.model.GetSipMediaApplicationLoggingConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
