package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkvoice.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters._
final case class DeleteVoiceConnectorOriginationRequest(
    voiceConnectorId: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorOriginationRequest = {
    import DeleteVoiceConnectorOriginationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorOriginationRequest
      .builder()
      .voiceConnectorId(
        NonEmptyString.unwrap(voiceConnectorId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.DeleteVoiceConnectorOriginationRequest.ReadOnly =
    zio.aws.chimesdkvoice.model.DeleteVoiceConnectorOriginationRequest
      .wrap(buildAwsValue())
}
object DeleteVoiceConnectorOriginationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorOriginationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkvoice.model.DeleteVoiceConnectorOriginationRequest =
      zio.aws.chimesdkvoice.model
        .DeleteVoiceConnectorOriginationRequest(voiceConnectorId)
    def voiceConnectorId: NonEmptyString
    def getVoiceConnectorId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(voiceConnectorId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorOriginationRequest
  ) extends zio.aws.chimesdkvoice.model.DeleteVoiceConnectorOriginationRequest.ReadOnly {
    override val voiceConnectorId: NonEmptyString =
      zio.aws.chimesdkvoice.model.primitives
        .NonEmptyString(impl.voiceConnectorId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorOriginationRequest
  ): zio.aws.chimesdkvoice.model.DeleteVoiceConnectorOriginationRequest.ReadOnly =
    new Wrapper(impl)
}
