package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkvoice.model.primitives.SipMediaApplicationName
import scala.jdk.CollectionConverters._
final case class CreateSipMediaApplicationRequest(
    awsRegion: String,
    name: SipMediaApplicationName,
    endpoints: Iterable[
      zio.aws.chimesdkvoice.model.SipMediaApplicationEndpoint
    ],
    tags: Optional[Iterable[zio.aws.chimesdkvoice.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.CreateSipMediaApplicationRequest = {
    import CreateSipMediaApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.CreateSipMediaApplicationRequest
      .builder()
      .awsRegion(awsRegion: java.lang.String)
      .name(SipMediaApplicationName.unwrap(name): java.lang.String)
      .endpoints(endpoints.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.CreateSipMediaApplicationRequest.ReadOnly =
    zio.aws.chimesdkvoice.model.CreateSipMediaApplicationRequest
      .wrap(buildAwsValue())
}
object CreateSipMediaApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.CreateSipMediaApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkvoice.model.CreateSipMediaApplicationRequest =
      zio.aws.chimesdkvoice.model.CreateSipMediaApplicationRequest(
        awsRegion,
        name,
        endpoints.map { item =>
          item.asEditable
        },
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def awsRegion: String
    def name: SipMediaApplicationName
    def endpoints
        : List[zio.aws.chimesdkvoice.model.SipMediaApplicationEndpoint.ReadOnly]
    def tags: Optional[List[zio.aws.chimesdkvoice.model.Tag.ReadOnly]]
    def getAwsRegion: ZIO[Any, Nothing, String] = ZIO.succeed(awsRegion)
    def getName: ZIO[Any, Nothing, SipMediaApplicationName] = ZIO.succeed(name)
    def getEndpoints: ZIO[Any, Nothing, List[
      zio.aws.chimesdkvoice.model.SipMediaApplicationEndpoint.ReadOnly
    ]] = ZIO.succeed(endpoints)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.chimesdkvoice.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.CreateSipMediaApplicationRequest
  ) extends zio.aws.chimesdkvoice.model.CreateSipMediaApplicationRequest.ReadOnly {
    override val awsRegion: String = impl.awsRegion(): String
    override val name: SipMediaApplicationName =
      zio.aws.chimesdkvoice.model.primitives
        .SipMediaApplicationName(impl.name())
    override val endpoints: List[
      zio.aws.chimesdkvoice.model.SipMediaApplicationEndpoint.ReadOnly
    ] = impl
      .endpoints()
      .asScala
      .map { item =>
        zio.aws.chimesdkvoice.model.SipMediaApplicationEndpoint.wrap(item)
      }
      .toList
    override val tags
        : Optional[List[zio.aws.chimesdkvoice.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chimesdkvoice.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.CreateSipMediaApplicationRequest
  ): zio.aws.chimesdkvoice.model.CreateSipMediaApplicationRequest.ReadOnly =
    new Wrapper(impl)
}
