package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateProxySessionResponse(
    proxySession: Optional[zio.aws.chimesdkvoice.model.ProxySession] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.CreateProxySessionResponse = {
    import CreateProxySessionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.CreateProxySessionResponse
      .builder()
      .optionallyWith(proxySession.map(value => value.buildAwsValue()))(
        _.proxySession
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.CreateProxySessionResponse.ReadOnly =
    zio.aws.chimesdkvoice.model.CreateProxySessionResponse.wrap(buildAwsValue())
}
object CreateProxySessionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.CreateProxySessionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.CreateProxySessionResponse =
      zio.aws.chimesdkvoice.model
        .CreateProxySessionResponse(proxySession.map(value => value.asEditable))
    def proxySession
        : Optional[zio.aws.chimesdkvoice.model.ProxySession.ReadOnly]
    def getProxySession: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkvoice.model.ProxySession.ReadOnly
    ] = AwsError.unwrapOptionField("proxySession", proxySession)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.CreateProxySessionResponse
  ) extends zio.aws.chimesdkvoice.model.CreateProxySessionResponse.ReadOnly {
    override val proxySession
        : Optional[zio.aws.chimesdkvoice.model.ProxySession.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.proxySession())
        .map(value => zio.aws.chimesdkvoice.model.ProxySession.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.CreateProxySessionResponse
  ): zio.aws.chimesdkvoice.model.CreateProxySessionResponse.ReadOnly =
    new Wrapper(impl)
}
