package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkvoice.model.primitives.E164PhoneNumber
import scala.jdk.CollectionConverters._
final case class CreatePhoneNumberOrderRequest(
    productType: zio.aws.chimesdkvoice.model.PhoneNumberProductType,
    e164PhoneNumbers: Iterable[E164PhoneNumber]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.CreatePhoneNumberOrderRequest = {
    import CreatePhoneNumberOrderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.CreatePhoneNumberOrderRequest
      .builder()
      .productType(productType.unwrap)
      .e164PhoneNumbers(e164PhoneNumbers.map { item =>
        E164PhoneNumber.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.CreatePhoneNumberOrderRequest.ReadOnly =
    zio.aws.chimesdkvoice.model.CreatePhoneNumberOrderRequest
      .wrap(buildAwsValue())
}
object CreatePhoneNumberOrderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.CreatePhoneNumberOrderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.CreatePhoneNumberOrderRequest =
      zio.aws.chimesdkvoice.model
        .CreatePhoneNumberOrderRequest(productType, e164PhoneNumbers)
    def productType: zio.aws.chimesdkvoice.model.PhoneNumberProductType
    def e164PhoneNumbers: List[E164PhoneNumber]
    def getProductType: ZIO[
      Any,
      Nothing,
      zio.aws.chimesdkvoice.model.PhoneNumberProductType
    ] = ZIO.succeed(productType)
    def getE164PhoneNumbers: ZIO[Any, Nothing, List[E164PhoneNumber]] =
      ZIO.succeed(e164PhoneNumbers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.CreatePhoneNumberOrderRequest
  ) extends zio.aws.chimesdkvoice.model.CreatePhoneNumberOrderRequest.ReadOnly {
    override val productType
        : zio.aws.chimesdkvoice.model.PhoneNumberProductType =
      zio.aws.chimesdkvoice.model.PhoneNumberProductType
        .wrap(impl.productType())
    override val e164PhoneNumbers: List[E164PhoneNumber] = impl
      .e164PhoneNumbers()
      .asScala
      .map { item =>
        zio.aws.chimesdkvoice.model.primitives.E164PhoneNumber(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.CreatePhoneNumberOrderRequest
  ): zio.aws.chimesdkvoice.model.CreatePhoneNumberOrderRequest.ReadOnly =
    new Wrapper(impl)
}
