package zio.aws.chimesdkvoice.model
import scala.jdk.CollectionConverters._
sealed trait Capability {
  def unwrap: software.amazon.awssdk.services.chimesdkvoice.model.Capability
}
object Capability {
  def wrap(
      value: software.amazon.awssdk.services.chimesdkvoice.model.Capability
  ): zio.aws.chimesdkvoice.model.Capability = value match {
    case software.amazon.awssdk.services.chimesdkvoice.model.Capability.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.chimesdkvoice.model.Capability.VOICE =>
      val r = Voice
      r
    case software.amazon.awssdk.services.chimesdkvoice.model.Capability.SMS =>
      val r = SMS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.chimesdkvoice.model.Capability {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkvoice.model.Capability =
      software.amazon.awssdk.services.chimesdkvoice.model.Capability.UNKNOWN_TO_SDK_VERSION
  }
  case object Voice extends zio.aws.chimesdkvoice.model.Capability {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkvoice.model.Capability =
      software.amazon.awssdk.services.chimesdkvoice.model.Capability.VOICE
  }
  case object SMS extends zio.aws.chimesdkvoice.model.Capability {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkvoice.model.Capability =
      software.amazon.awssdk.services.chimesdkvoice.model.Capability.SMS
  }
}
