package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VoiceConnectorSettings(
    cdrBucket: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.VoiceConnectorSettings = {
    import VoiceConnectorSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.VoiceConnectorSettings
      .builder()
      .optionallyWith(cdrBucket.map(value => value: java.lang.String))(
        _.cdrBucket
      )
      .build()
  }
  def asReadOnly: zio.aws.chimesdkvoice.model.VoiceConnectorSettings.ReadOnly =
    zio.aws.chimesdkvoice.model.VoiceConnectorSettings.wrap(buildAwsValue())
}
object VoiceConnectorSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.VoiceConnectorSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.VoiceConnectorSettings =
      zio.aws.chimesdkvoice.model
        .VoiceConnectorSettings(cdrBucket.map(value => value))
    def cdrBucket: Optional[String]
    def getCdrBucket: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cdrBucket", cdrBucket)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.VoiceConnectorSettings
  ) extends zio.aws.chimesdkvoice.model.VoiceConnectorSettings.ReadOnly {
    override val cdrBucket: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cdrBucket())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.VoiceConnectorSettings
  ): zio.aws.chimesdkvoice.model.VoiceConnectorSettings.ReadOnly = new Wrapper(
    impl
  )
}
