package zio.aws.chimesdkvoice.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkvoice.model.primitives.{
  VoiceConnectorItemPriority,
  NonEmptyString
}
import scala.jdk.CollectionConverters._
final case class VoiceConnectorItem(
    voiceConnectorId: NonEmptyString,
    priority: VoiceConnectorItemPriority
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.VoiceConnectorItem = {
    import VoiceConnectorItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.VoiceConnectorItem
      .builder()
      .voiceConnectorId(
        NonEmptyString.unwrap(voiceConnectorId): java.lang.String
      )
      .priority(VoiceConnectorItemPriority.unwrap(priority): Integer)
      .build()
  }
  def asReadOnly: zio.aws.chimesdkvoice.model.VoiceConnectorItem.ReadOnly =
    zio.aws.chimesdkvoice.model.VoiceConnectorItem.wrap(buildAwsValue())
}
object VoiceConnectorItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.VoiceConnectorItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.VoiceConnectorItem =
      zio.aws.chimesdkvoice.model.VoiceConnectorItem(voiceConnectorId, priority)
    def voiceConnectorId: NonEmptyString
    def priority: VoiceConnectorItemPriority
    def getVoiceConnectorId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(voiceConnectorId)
    def getPriority: ZIO[Any, Nothing, VoiceConnectorItemPriority] =
      ZIO.succeed(priority)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.VoiceConnectorItem
  ) extends zio.aws.chimesdkvoice.model.VoiceConnectorItem.ReadOnly {
    override val voiceConnectorId: NonEmptyString =
      zio.aws.chimesdkvoice.model.primitives
        .NonEmptyString(impl.voiceConnectorId())
    override val priority: VoiceConnectorItemPriority =
      zio.aws.chimesdkvoice.model.primitives
        .VoiceConnectorItemPriority(impl.priority())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.VoiceConnectorItem
  ): zio.aws.chimesdkvoice.model.VoiceConnectorItem.ReadOnly = new Wrapper(impl)
}
