package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkvoice.model.primitives.NonEmptyString256
import scala.jdk.CollectionConverters._
final case class UpdateVoiceProfileRequest(
    voiceProfileId: NonEmptyString256,
    speakerSearchTaskId: NonEmptyString256
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.UpdateVoiceProfileRequest = {
    import UpdateVoiceProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.UpdateVoiceProfileRequest
      .builder()
      .voiceProfileId(
        NonEmptyString256.unwrap(voiceProfileId): java.lang.String
      )
      .speakerSearchTaskId(
        NonEmptyString256.unwrap(speakerSearchTaskId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.UpdateVoiceProfileRequest.ReadOnly =
    zio.aws.chimesdkvoice.model.UpdateVoiceProfileRequest.wrap(buildAwsValue())
}
object UpdateVoiceProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.UpdateVoiceProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.UpdateVoiceProfileRequest =
      zio.aws.chimesdkvoice.model
        .UpdateVoiceProfileRequest(voiceProfileId, speakerSearchTaskId)
    def voiceProfileId: NonEmptyString256
    def speakerSearchTaskId: NonEmptyString256
    def getVoiceProfileId: ZIO[Any, Nothing, NonEmptyString256] =
      ZIO.succeed(voiceProfileId)
    def getSpeakerSearchTaskId: ZIO[Any, Nothing, NonEmptyString256] =
      ZIO.succeed(speakerSearchTaskId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.UpdateVoiceProfileRequest
  ) extends zio.aws.chimesdkvoice.model.UpdateVoiceProfileRequest.ReadOnly {
    override val voiceProfileId: NonEmptyString256 =
      zio.aws.chimesdkvoice.model.primitives
        .NonEmptyString256(impl.voiceProfileId())
    override val speakerSearchTaskId: NonEmptyString256 =
      zio.aws.chimesdkvoice.model.primitives
        .NonEmptyString256(impl.speakerSearchTaskId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.UpdateVoiceProfileRequest
  ): zio.aws.chimesdkvoice.model.UpdateVoiceProfileRequest.ReadOnly =
    new Wrapper(impl)
}
