package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkvoice.model.primitives.CallingName
import scala.jdk.CollectionConverters._
final case class UpdatePhoneNumberSettingsRequest(callingName: CallingName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.UpdatePhoneNumberSettingsRequest = {
    import UpdatePhoneNumberSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.UpdatePhoneNumberSettingsRequest
      .builder()
      .callingName(CallingName.unwrap(callingName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.UpdatePhoneNumberSettingsRequest.ReadOnly =
    zio.aws.chimesdkvoice.model.UpdatePhoneNumberSettingsRequest
      .wrap(buildAwsValue())
}
object UpdatePhoneNumberSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.UpdatePhoneNumberSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkvoice.model.UpdatePhoneNumberSettingsRequest =
      zio.aws.chimesdkvoice.model.UpdatePhoneNumberSettingsRequest(callingName)
    def callingName: CallingName
    def getCallingName: ZIO[Any, Nothing, CallingName] =
      ZIO.succeed(callingName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.UpdatePhoneNumberSettingsRequest
  ) extends zio.aws.chimesdkvoice.model.UpdatePhoneNumberSettingsRequest.ReadOnly {
    override val callingName: CallingName =
      zio.aws.chimesdkvoice.model.primitives.CallingName(impl.callingName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.UpdatePhoneNumberSettingsRequest
  ): zio.aws.chimesdkvoice.model.UpdatePhoneNumberSettingsRequest.ReadOnly =
    new Wrapper(impl)
}
