package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdatePhoneNumberResponse(
    phoneNumber: Optional[zio.aws.chimesdkvoice.model.PhoneNumber] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.UpdatePhoneNumberResponse = {
    import UpdatePhoneNumberResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.UpdatePhoneNumberResponse
      .builder()
      .optionallyWith(phoneNumber.map(value => value.buildAwsValue()))(
        _.phoneNumber
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.UpdatePhoneNumberResponse.ReadOnly =
    zio.aws.chimesdkvoice.model.UpdatePhoneNumberResponse.wrap(buildAwsValue())
}
object UpdatePhoneNumberResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.UpdatePhoneNumberResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.UpdatePhoneNumberResponse =
      zio.aws.chimesdkvoice.model
        .UpdatePhoneNumberResponse(phoneNumber.map(value => value.asEditable))
    def phoneNumber: Optional[zio.aws.chimesdkvoice.model.PhoneNumber.ReadOnly]
    def getPhoneNumber
        : ZIO[Any, AwsError, zio.aws.chimesdkvoice.model.PhoneNumber.ReadOnly] =
      AwsError.unwrapOptionField("phoneNumber", phoneNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.UpdatePhoneNumberResponse
  ) extends zio.aws.chimesdkvoice.model.UpdatePhoneNumberResponse.ReadOnly {
    override val phoneNumber
        : Optional[zio.aws.chimesdkvoice.model.PhoneNumber.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.phoneNumber())
        .map(value => zio.aws.chimesdkvoice.model.PhoneNumber.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.UpdatePhoneNumberResponse
  ): zio.aws.chimesdkvoice.model.UpdatePhoneNumberResponse.ReadOnly =
    new Wrapper(impl)
}
