package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateGlobalSettingsRequest(
    voiceConnector: Optional[
      zio.aws.chimesdkvoice.model.VoiceConnectorSettings
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.UpdateGlobalSettingsRequest = {
    import UpdateGlobalSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.UpdateGlobalSettingsRequest
      .builder()
      .optionallyWith(voiceConnector.map(value => value.buildAwsValue()))(
        _.voiceConnector
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.UpdateGlobalSettingsRequest.ReadOnly =
    zio.aws.chimesdkvoice.model.UpdateGlobalSettingsRequest
      .wrap(buildAwsValue())
}
object UpdateGlobalSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.UpdateGlobalSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.UpdateGlobalSettingsRequest =
      zio.aws.chimesdkvoice.model.UpdateGlobalSettingsRequest(
        voiceConnector.map(value => value.asEditable)
      )
    def voiceConnector
        : Optional[zio.aws.chimesdkvoice.model.VoiceConnectorSettings.ReadOnly]
    def getVoiceConnector: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkvoice.model.VoiceConnectorSettings.ReadOnly
    ] = AwsError.unwrapOptionField("voiceConnector", voiceConnector)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.UpdateGlobalSettingsRequest
  ) extends zio.aws.chimesdkvoice.model.UpdateGlobalSettingsRequest.ReadOnly {
    override val voiceConnector: Optional[
      zio.aws.chimesdkvoice.model.VoiceConnectorSettings.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.voiceConnector())
      .map(value =>
        zio.aws.chimesdkvoice.model.VoiceConnectorSettings.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.UpdateGlobalSettingsRequest
  ): zio.aws.chimesdkvoice.model.UpdateGlobalSettingsRequest.ReadOnly =
    new Wrapper(impl)
}
