package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkvoice.model.primitives.Arn
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    resourceARN: Arn,
    tags: Iterable[zio.aws.chimesdkvoice.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.TagResourceRequest
      .builder()
      .resourceARN(Arn.unwrap(resourceARN): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.chimesdkvoice.model.TagResourceRequest.ReadOnly =
    zio.aws.chimesdkvoice.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.TagResourceRequest =
      zio.aws.chimesdkvoice.model.TagResourceRequest(
        resourceARN,
        tags.map { item =>
          item.asEditable
        }
      )
    def resourceARN: Arn
    def tags: List[zio.aws.chimesdkvoice.model.Tag.ReadOnly]
    def getResourceARN: ZIO[Any, Nothing, Arn] = ZIO.succeed(resourceARN)
    def getTags
        : ZIO[Any, Nothing, List[zio.aws.chimesdkvoice.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.TagResourceRequest
  ) extends zio.aws.chimesdkvoice.model.TagResourceRequest.ReadOnly {
    override val resourceARN: Arn =
      zio.aws.chimesdkvoice.model.primitives.Arn(impl.resourceARN())
    override val tags: List[zio.aws.chimesdkvoice.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.chimesdkvoice.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.TagResourceRequest
  ): zio.aws.chimesdkvoice.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
