package zio.aws.chimesdkvoice.model
import zio.aws.chimesdkvoice.model.primitives.{
  Iso8601Timestamp,
  NonEmptyString,
  NonEmptyString256
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class SpeakerSearchTask(
    speakerSearchTaskId: Optional[NonEmptyString256] = Optional.Absent,
    speakerSearchTaskStatus: Optional[NonEmptyString] = Optional.Absent,
    callDetails: Optional[zio.aws.chimesdkvoice.model.CallDetails] =
      Optional.Absent,
    speakerSearchDetails: Optional[
      zio.aws.chimesdkvoice.model.SpeakerSearchDetails
    ] = Optional.Absent,
    createdTimestamp: Optional[Iso8601Timestamp] = Optional.Absent,
    updatedTimestamp: Optional[Iso8601Timestamp] = Optional.Absent,
    startedTimestamp: Optional[Iso8601Timestamp] = Optional.Absent,
    statusMessage: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.SpeakerSearchTask = {
    import SpeakerSearchTask.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.SpeakerSearchTask
      .builder()
      .optionallyWith(
        speakerSearchTaskId.map(value =>
          NonEmptyString256.unwrap(value): java.lang.String
        )
      )(_.speakerSearchTaskId)
      .optionallyWith(
        speakerSearchTaskStatus.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.speakerSearchTaskStatus)
      .optionallyWith(callDetails.map(value => value.buildAwsValue()))(
        _.callDetails
      )
      .optionallyWith(speakerSearchDetails.map(value => value.buildAwsValue()))(
        _.speakerSearchDetails
      )
      .optionallyWith(
        createdTimestamp.map(value => Iso8601Timestamp.unwrap(value): Instant)
      )(_.createdTimestamp)
      .optionallyWith(
        updatedTimestamp.map(value => Iso8601Timestamp.unwrap(value): Instant)
      )(_.updatedTimestamp)
      .optionallyWith(
        startedTimestamp.map(value => Iso8601Timestamp.unwrap(value): Instant)
      )(_.startedTimestamp)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .build()
  }
  def asReadOnly: zio.aws.chimesdkvoice.model.SpeakerSearchTask.ReadOnly =
    zio.aws.chimesdkvoice.model.SpeakerSearchTask.wrap(buildAwsValue())
}
object SpeakerSearchTask {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.SpeakerSearchTask
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.SpeakerSearchTask =
      zio.aws.chimesdkvoice.model.SpeakerSearchTask(
        speakerSearchTaskId.map(value => value),
        speakerSearchTaskStatus.map(value => value),
        callDetails.map(value => value.asEditable),
        speakerSearchDetails.map(value => value.asEditable),
        createdTimestamp.map(value => value),
        updatedTimestamp.map(value => value),
        startedTimestamp.map(value => value),
        statusMessage.map(value => value)
      )
    def speakerSearchTaskId: Optional[NonEmptyString256]
    def speakerSearchTaskStatus: Optional[NonEmptyString]
    def callDetails: Optional[zio.aws.chimesdkvoice.model.CallDetails.ReadOnly]
    def speakerSearchDetails
        : Optional[zio.aws.chimesdkvoice.model.SpeakerSearchDetails.ReadOnly]
    def createdTimestamp: Optional[Iso8601Timestamp]
    def updatedTimestamp: Optional[Iso8601Timestamp]
    def startedTimestamp: Optional[Iso8601Timestamp]
    def statusMessage: Optional[String]
    def getSpeakerSearchTaskId: ZIO[Any, AwsError, NonEmptyString256] =
      AwsError.unwrapOptionField("speakerSearchTaskId", speakerSearchTaskId)
    def getSpeakerSearchTaskStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "speakerSearchTaskStatus",
        speakerSearchTaskStatus
      )
    def getCallDetails
        : ZIO[Any, AwsError, zio.aws.chimesdkvoice.model.CallDetails.ReadOnly] =
      AwsError.unwrapOptionField("callDetails", callDetails)
    def getSpeakerSearchDetails: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkvoice.model.SpeakerSearchDetails.ReadOnly
    ] = AwsError.unwrapOptionField("speakerSearchDetails", speakerSearchDetails)
    def getCreatedTimestamp: ZIO[Any, AwsError, Iso8601Timestamp] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
    def getUpdatedTimestamp: ZIO[Any, AwsError, Iso8601Timestamp] =
      AwsError.unwrapOptionField("updatedTimestamp", updatedTimestamp)
    def getStartedTimestamp: ZIO[Any, AwsError, Iso8601Timestamp] =
      AwsError.unwrapOptionField("startedTimestamp", startedTimestamp)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.SpeakerSearchTask
  ) extends zio.aws.chimesdkvoice.model.SpeakerSearchTask.ReadOnly {
    override val speakerSearchTaskId: Optional[NonEmptyString256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.speakerSearchTaskId())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.NonEmptyString256(value)
        )
    override val speakerSearchTaskStatus: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.speakerSearchTaskStatus())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.NonEmptyString(value)
        )
    override val callDetails
        : Optional[zio.aws.chimesdkvoice.model.CallDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.callDetails())
        .map(value => zio.aws.chimesdkvoice.model.CallDetails.wrap(value))
    override val speakerSearchDetails
        : Optional[zio.aws.chimesdkvoice.model.SpeakerSearchDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.speakerSearchDetails())
        .map(value =>
          zio.aws.chimesdkvoice.model.SpeakerSearchDetails.wrap(value)
        )
    override val createdTimestamp: Optional[Iso8601Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdTimestamp())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.Iso8601Timestamp(value)
        )
    override val updatedTimestamp: Optional[Iso8601Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updatedTimestamp())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.Iso8601Timestamp(value)
        )
    override val startedTimestamp: Optional[Iso8601Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.startedTimestamp())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.Iso8601Timestamp(value)
        )
    override val statusMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.SpeakerSearchTask
  ): zio.aws.chimesdkvoice.model.SpeakerSearchTask.ReadOnly = new Wrapper(impl)
}
