package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkvoice.model.primitives.{
  NonEmptyString256,
  ConfidenceScore
}
import scala.jdk.CollectionConverters._
final case class SpeakerSearchResult(
    confidenceScore: Optional[ConfidenceScore] = Optional.Absent,
    voiceProfileId: Optional[NonEmptyString256] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.SpeakerSearchResult = {
    import SpeakerSearchResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.SpeakerSearchResult
      .builder()
      .optionallyWith(
        confidenceScore.map(value =>
          ConfidenceScore.unwrap(value): java.lang.Float
        )
      )(_.confidenceScore)
      .optionallyWith(
        voiceProfileId.map(value =>
          NonEmptyString256.unwrap(value): java.lang.String
        )
      )(_.voiceProfileId)
      .build()
  }
  def asReadOnly: zio.aws.chimesdkvoice.model.SpeakerSearchResult.ReadOnly =
    zio.aws.chimesdkvoice.model.SpeakerSearchResult.wrap(buildAwsValue())
}
object SpeakerSearchResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.SpeakerSearchResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.SpeakerSearchResult =
      zio.aws.chimesdkvoice.model.SpeakerSearchResult(
        confidenceScore.map(value => value),
        voiceProfileId.map(value => value)
      )
    def confidenceScore: Optional[ConfidenceScore]
    def voiceProfileId: Optional[NonEmptyString256]
    def getConfidenceScore: ZIO[Any, AwsError, ConfidenceScore] =
      AwsError.unwrapOptionField("confidenceScore", confidenceScore)
    def getVoiceProfileId: ZIO[Any, AwsError, NonEmptyString256] =
      AwsError.unwrapOptionField("voiceProfileId", voiceProfileId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.SpeakerSearchResult
  ) extends zio.aws.chimesdkvoice.model.SpeakerSearchResult.ReadOnly {
    override val confidenceScore: Optional[ConfidenceScore] =
      zio.aws.core.internal
        .optionalFromNullable(impl.confidenceScore())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.ConfidenceScore(value)
        )
    override val voiceProfileId: Optional[NonEmptyString256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.voiceProfileId())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.NonEmptyString256(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.SpeakerSearchResult
  ): zio.aws.chimesdkvoice.model.SpeakerSearchResult.ReadOnly = new Wrapper(
    impl
  )
}
