package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkvoice.model.primitives.GuidString
import scala.jdk.CollectionConverters._
final case class SipMediaApplicationCall(
    transactionId: Optional[GuidString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.SipMediaApplicationCall = {
    import SipMediaApplicationCall.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.SipMediaApplicationCall
      .builder()
      .optionallyWith(
        transactionId.map(value => GuidString.unwrap(value): java.lang.String)
      )(_.transactionId)
      .build()
  }
  def asReadOnly: zio.aws.chimesdkvoice.model.SipMediaApplicationCall.ReadOnly =
    zio.aws.chimesdkvoice.model.SipMediaApplicationCall.wrap(buildAwsValue())
}
object SipMediaApplicationCall {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.SipMediaApplicationCall
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.SipMediaApplicationCall =
      zio.aws.chimesdkvoice.model
        .SipMediaApplicationCall(transactionId.map(value => value))
    def transactionId: Optional[GuidString]
    def getTransactionId: ZIO[Any, AwsError, GuidString] =
      AwsError.unwrapOptionField("transactionId", transactionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.SipMediaApplicationCall
  ) extends zio.aws.chimesdkvoice.model.SipMediaApplicationCall.ReadOnly {
    override val transactionId: Optional[GuidString] = zio.aws.core.internal
      .optionalFromNullable(impl.transactionId())
      .map(value => zio.aws.chimesdkvoice.model.primitives.GuidString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.SipMediaApplicationCall
  ): zio.aws.chimesdkvoice.model.SipMediaApplicationCall.ReadOnly = new Wrapper(
    impl
  )
}
