package zio.aws.chimesdkvoice.model
import zio.aws.chimesdkvoice.model.primitives.{
  Iso8601Timestamp,
  SipMediaApplicationName,
  NonEmptyString
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class SipMediaApplication(
    sipMediaApplicationId: Optional[NonEmptyString] = Optional.Absent,
    awsRegion: Optional[String] = Optional.Absent,
    name: Optional[SipMediaApplicationName] = Optional.Absent,
    endpoints: Optional[
      Iterable[zio.aws.chimesdkvoice.model.SipMediaApplicationEndpoint]
    ] = Optional.Absent,
    createdTimestamp: Optional[Iso8601Timestamp] = Optional.Absent,
    updatedTimestamp: Optional[Iso8601Timestamp] = Optional.Absent,
    sipMediaApplicationArn: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.SipMediaApplication = {
    import SipMediaApplication.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.SipMediaApplication
      .builder()
      .optionallyWith(
        sipMediaApplicationId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.sipMediaApplicationId)
      .optionallyWith(awsRegion.map(value => value: java.lang.String))(
        _.awsRegion
      )
      .optionallyWith(
        name.map(value =>
          SipMediaApplicationName.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(
        endpoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.endpoints)
      .optionallyWith(
        createdTimestamp.map(value => Iso8601Timestamp.unwrap(value): Instant)
      )(_.createdTimestamp)
      .optionallyWith(
        updatedTimestamp.map(value => Iso8601Timestamp.unwrap(value): Instant)
      )(_.updatedTimestamp)
      .optionallyWith(
        sipMediaApplicationArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.sipMediaApplicationArn)
      .build()
  }
  def asReadOnly: zio.aws.chimesdkvoice.model.SipMediaApplication.ReadOnly =
    zio.aws.chimesdkvoice.model.SipMediaApplication.wrap(buildAwsValue())
}
object SipMediaApplication {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.SipMediaApplication
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.SipMediaApplication =
      zio.aws.chimesdkvoice.model.SipMediaApplication(
        sipMediaApplicationId.map(value => value),
        awsRegion.map(value => value),
        name.map(value => value),
        endpoints.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        createdTimestamp.map(value => value),
        updatedTimestamp.map(value => value),
        sipMediaApplicationArn.map(value => value)
      )
    def sipMediaApplicationId: Optional[NonEmptyString]
    def awsRegion: Optional[String]
    def name: Optional[SipMediaApplicationName]
    def endpoints: Optional[
      List[zio.aws.chimesdkvoice.model.SipMediaApplicationEndpoint.ReadOnly]
    ]
    def createdTimestamp: Optional[Iso8601Timestamp]
    def updatedTimestamp: Optional[Iso8601Timestamp]
    def sipMediaApplicationArn: Optional[NonEmptyString]
    def getSipMediaApplicationId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("sipMediaApplicationId", sipMediaApplicationId)
    def getAwsRegion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("awsRegion", awsRegion)
    def getName: ZIO[Any, AwsError, SipMediaApplicationName] =
      AwsError.unwrapOptionField("name", name)
    def getEndpoints: ZIO[Any, AwsError, List[
      zio.aws.chimesdkvoice.model.SipMediaApplicationEndpoint.ReadOnly
    ]] = AwsError.unwrapOptionField("endpoints", endpoints)
    def getCreatedTimestamp: ZIO[Any, AwsError, Iso8601Timestamp] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
    def getUpdatedTimestamp: ZIO[Any, AwsError, Iso8601Timestamp] =
      AwsError.unwrapOptionField("updatedTimestamp", updatedTimestamp)
    def getSipMediaApplicationArn: ZIO[Any, AwsError, NonEmptyString] = AwsError
      .unwrapOptionField("sipMediaApplicationArn", sipMediaApplicationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.SipMediaApplication
  ) extends zio.aws.chimesdkvoice.model.SipMediaApplication.ReadOnly {
    override val sipMediaApplicationId: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sipMediaApplicationId())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.NonEmptyString(value)
        )
    override val awsRegion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.awsRegion())
      .map(value => value: String)
    override val name: Optional[SipMediaApplicationName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.chimesdkvoice.model.primitives.SipMediaApplicationName(value)
      )
    override val endpoints: Optional[
      List[zio.aws.chimesdkvoice.model.SipMediaApplicationEndpoint.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.endpoints())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.chimesdkvoice.model.SipMediaApplicationEndpoint.wrap(item)
        }.toList
      )
    override val createdTimestamp: Optional[Iso8601Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdTimestamp())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.Iso8601Timestamp(value)
        )
    override val updatedTimestamp: Optional[Iso8601Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updatedTimestamp())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.Iso8601Timestamp(value)
        )
    override val sipMediaApplicationArn: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sipMediaApplicationArn())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.NonEmptyString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.SipMediaApplication
  ): zio.aws.chimesdkvoice.model.SipMediaApplication.ReadOnly = new Wrapper(
    impl
  )
}
