package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkvoice.model.primitives.Arn
import scala.jdk.CollectionConverters._
final case class ServerSideEncryptionConfiguration(kmsKeyArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.ServerSideEncryptionConfiguration = {
    import ServerSideEncryptionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.ServerSideEncryptionConfiguration
      .builder()
      .kmsKeyArn(Arn.unwrap(kmsKeyArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.ServerSideEncryptionConfiguration.ReadOnly =
    zio.aws.chimesdkvoice.model.ServerSideEncryptionConfiguration
      .wrap(buildAwsValue())
}
object ServerSideEncryptionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.ServerSideEncryptionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkvoice.model.ServerSideEncryptionConfiguration =
      zio.aws.chimesdkvoice.model.ServerSideEncryptionConfiguration(kmsKeyArn)
    def kmsKeyArn: Arn
    def getKmsKeyArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(kmsKeyArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.ServerSideEncryptionConfiguration
  ) extends zio.aws.chimesdkvoice.model.ServerSideEncryptionConfiguration.ReadOnly {
    override val kmsKeyArn: Arn =
      zio.aws.chimesdkvoice.model.primitives.Arn(impl.kmsKeyArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.ServerSideEncryptionConfiguration
  ): zio.aws.chimesdkvoice.model.ServerSideEncryptionConfiguration.ReadOnly =
    new Wrapper(impl)
}
