package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RestorePhoneNumberResponse(
    phoneNumber: Optional[zio.aws.chimesdkvoice.model.PhoneNumber] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.RestorePhoneNumberResponse = {
    import RestorePhoneNumberResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.RestorePhoneNumberResponse
      .builder()
      .optionallyWith(phoneNumber.map(value => value.buildAwsValue()))(
        _.phoneNumber
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.RestorePhoneNumberResponse.ReadOnly =
    zio.aws.chimesdkvoice.model.RestorePhoneNumberResponse.wrap(buildAwsValue())
}
object RestorePhoneNumberResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.RestorePhoneNumberResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.RestorePhoneNumberResponse =
      zio.aws.chimesdkvoice.model
        .RestorePhoneNumberResponse(phoneNumber.map(value => value.asEditable))
    def phoneNumber: Optional[zio.aws.chimesdkvoice.model.PhoneNumber.ReadOnly]
    def getPhoneNumber
        : ZIO[Any, AwsError, zio.aws.chimesdkvoice.model.PhoneNumber.ReadOnly] =
      AwsError.unwrapOptionField("phoneNumber", phoneNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.RestorePhoneNumberResponse
  ) extends zio.aws.chimesdkvoice.model.RestorePhoneNumberResponse.ReadOnly {
    override val phoneNumber
        : Optional[zio.aws.chimesdkvoice.model.PhoneNumber.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.phoneNumber())
        .map(value => zio.aws.chimesdkvoice.model.PhoneNumber.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.RestorePhoneNumberResponse
  ): zio.aws.chimesdkvoice.model.RestorePhoneNumberResponse.ReadOnly =
    new Wrapper(impl)
}
