package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkvoice.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters._
final case class PutVoiceConnectorTerminationRequest(
    voiceConnectorId: NonEmptyString,
    termination: zio.aws.chimesdkvoice.model.Termination
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorTerminationRequest = {
    import PutVoiceConnectorTerminationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorTerminationRequest
      .builder()
      .voiceConnectorId(
        NonEmptyString.unwrap(voiceConnectorId): java.lang.String
      )
      .termination(termination.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.PutVoiceConnectorTerminationRequest.ReadOnly =
    zio.aws.chimesdkvoice.model.PutVoiceConnectorTerminationRequest
      .wrap(buildAwsValue())
}
object PutVoiceConnectorTerminationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorTerminationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkvoice.model.PutVoiceConnectorTerminationRequest =
      zio.aws.chimesdkvoice.model.PutVoiceConnectorTerminationRequest(
        voiceConnectorId,
        termination.asEditable
      )
    def voiceConnectorId: NonEmptyString
    def termination: zio.aws.chimesdkvoice.model.Termination.ReadOnly
    def getVoiceConnectorId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(voiceConnectorId)
    def getTermination
        : ZIO[Any, Nothing, zio.aws.chimesdkvoice.model.Termination.ReadOnly] =
      ZIO.succeed(termination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorTerminationRequest
  ) extends zio.aws.chimesdkvoice.model.PutVoiceConnectorTerminationRequest.ReadOnly {
    override val voiceConnectorId: NonEmptyString =
      zio.aws.chimesdkvoice.model.primitives
        .NonEmptyString(impl.voiceConnectorId())
    override val termination: zio.aws.chimesdkvoice.model.Termination.ReadOnly =
      zio.aws.chimesdkvoice.model.Termination.wrap(impl.termination())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorTerminationRequest
  ): zio.aws.chimesdkvoice.model.PutVoiceConnectorTerminationRequest.ReadOnly =
    new Wrapper(impl)
}
