package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkvoice.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters._
final case class PutVoiceConnectorOriginationRequest(
    voiceConnectorId: NonEmptyString,
    origination: zio.aws.chimesdkvoice.model.Origination
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorOriginationRequest = {
    import PutVoiceConnectorOriginationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorOriginationRequest
      .builder()
      .voiceConnectorId(
        NonEmptyString.unwrap(voiceConnectorId): java.lang.String
      )
      .origination(origination.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.PutVoiceConnectorOriginationRequest.ReadOnly =
    zio.aws.chimesdkvoice.model.PutVoiceConnectorOriginationRequest
      .wrap(buildAwsValue())
}
object PutVoiceConnectorOriginationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorOriginationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkvoice.model.PutVoiceConnectorOriginationRequest =
      zio.aws.chimesdkvoice.model.PutVoiceConnectorOriginationRequest(
        voiceConnectorId,
        origination.asEditable
      )
    def voiceConnectorId: NonEmptyString
    def origination: zio.aws.chimesdkvoice.model.Origination.ReadOnly
    def getVoiceConnectorId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(voiceConnectorId)
    def getOrigination
        : ZIO[Any, Nothing, zio.aws.chimesdkvoice.model.Origination.ReadOnly] =
      ZIO.succeed(origination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorOriginationRequest
  ) extends zio.aws.chimesdkvoice.model.PutVoiceConnectorOriginationRequest.ReadOnly {
    override val voiceConnectorId: NonEmptyString =
      zio.aws.chimesdkvoice.model.primitives
        .NonEmptyString(impl.voiceConnectorId())
    override val origination: zio.aws.chimesdkvoice.model.Origination.ReadOnly =
      zio.aws.chimesdkvoice.model.Origination.wrap(impl.origination())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorOriginationRequest
  ): zio.aws.chimesdkvoice.model.PutVoiceConnectorOriginationRequest.ReadOnly =
    new Wrapper(impl)
}
