package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutSipMediaApplicationLoggingConfigurationResponse(
    sipMediaApplicationLoggingConfiguration: Optional[
      zio.aws.chimesdkvoice.model.SipMediaApplicationLoggingConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.PutSipMediaApplicationLoggingConfigurationResponse = {
    import PutSipMediaApplicationLoggingConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.PutSipMediaApplicationLoggingConfigurationResponse
      .builder()
      .optionallyWith(
        sipMediaApplicationLoggingConfiguration.map(value =>
          value.buildAwsValue()
        )
      )(_.sipMediaApplicationLoggingConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.PutSipMediaApplicationLoggingConfigurationResponse.ReadOnly =
    zio.aws.chimesdkvoice.model.PutSipMediaApplicationLoggingConfigurationResponse
      .wrap(buildAwsValue())
}
object PutSipMediaApplicationLoggingConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.PutSipMediaApplicationLoggingConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkvoice.model.PutSipMediaApplicationLoggingConfigurationResponse =
      zio.aws.chimesdkvoice.model
        .PutSipMediaApplicationLoggingConfigurationResponse(
          sipMediaApplicationLoggingConfiguration.map(value => value.asEditable)
        )
    def sipMediaApplicationLoggingConfiguration: Optional[
      zio.aws.chimesdkvoice.model.SipMediaApplicationLoggingConfiguration.ReadOnly
    ]
    def getSipMediaApplicationLoggingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkvoice.model.SipMediaApplicationLoggingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "sipMediaApplicationLoggingConfiguration",
      sipMediaApplicationLoggingConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.PutSipMediaApplicationLoggingConfigurationResponse
  ) extends zio.aws.chimesdkvoice.model.PutSipMediaApplicationLoggingConfigurationResponse.ReadOnly {
    override val sipMediaApplicationLoggingConfiguration: Optional[
      zio.aws.chimesdkvoice.model.SipMediaApplicationLoggingConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sipMediaApplicationLoggingConfiguration())
      .map(value =>
        zio.aws.chimesdkvoice.model.SipMediaApplicationLoggingConfiguration
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.PutSipMediaApplicationLoggingConfigurationResponse
  ): zio.aws.chimesdkvoice.model.PutSipMediaApplicationLoggingConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
