package zio.aws.chimesdkvoice.model
import zio.aws.chimesdkvoice.model.primitives.{Iso8601Timestamp, GuidString}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class PhoneNumberOrder(
    phoneNumberOrderId: Optional[GuidString] = Optional.Absent,
    productType: Optional[zio.aws.chimesdkvoice.model.PhoneNumberProductType] =
      Optional.Absent,
    status: Optional[zio.aws.chimesdkvoice.model.PhoneNumberOrderStatus] =
      Optional.Absent,
    orderType: Optional[zio.aws.chimesdkvoice.model.PhoneNumberOrderType] =
      Optional.Absent,
    orderedPhoneNumbers: Optional[
      Iterable[zio.aws.chimesdkvoice.model.OrderedPhoneNumber]
    ] = Optional.Absent,
    createdTimestamp: Optional[Iso8601Timestamp] = Optional.Absent,
    updatedTimestamp: Optional[Iso8601Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.PhoneNumberOrder = {
    import PhoneNumberOrder.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.PhoneNumberOrder
      .builder()
      .optionallyWith(
        phoneNumberOrderId.map(value =>
          GuidString.unwrap(value): java.lang.String
        )
      )(_.phoneNumberOrderId)
      .optionallyWith(productType.map(value => value.unwrap))(_.productType)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(orderType.map(value => value.unwrap))(_.orderType)
      .optionallyWith(
        orderedPhoneNumbers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.orderedPhoneNumbers)
      .optionallyWith(
        createdTimestamp.map(value => Iso8601Timestamp.unwrap(value): Instant)
      )(_.createdTimestamp)
      .optionallyWith(
        updatedTimestamp.map(value => Iso8601Timestamp.unwrap(value): Instant)
      )(_.updatedTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.chimesdkvoice.model.PhoneNumberOrder.ReadOnly =
    zio.aws.chimesdkvoice.model.PhoneNumberOrder.wrap(buildAwsValue())
}
object PhoneNumberOrder {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.PhoneNumberOrder
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.PhoneNumberOrder =
      zio.aws.chimesdkvoice.model.PhoneNumberOrder(
        phoneNumberOrderId.map(value => value),
        productType.map(value => value),
        status.map(value => value),
        orderType.map(value => value),
        orderedPhoneNumbers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        createdTimestamp.map(value => value),
        updatedTimestamp.map(value => value)
      )
    def phoneNumberOrderId: Optional[GuidString]
    def productType
        : Optional[zio.aws.chimesdkvoice.model.PhoneNumberProductType]
    def status: Optional[zio.aws.chimesdkvoice.model.PhoneNumberOrderStatus]
    def orderType: Optional[zio.aws.chimesdkvoice.model.PhoneNumberOrderType]
    def orderedPhoneNumbers: Optional[
      List[zio.aws.chimesdkvoice.model.OrderedPhoneNumber.ReadOnly]
    ]
    def createdTimestamp: Optional[Iso8601Timestamp]
    def updatedTimestamp: Optional[Iso8601Timestamp]
    def getPhoneNumberOrderId: ZIO[Any, AwsError, GuidString] =
      AwsError.unwrapOptionField("phoneNumberOrderId", phoneNumberOrderId)
    def getProductType: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkvoice.model.PhoneNumberProductType
    ] = AwsError.unwrapOptionField("productType", productType)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkvoice.model.PhoneNumberOrderStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getOrderType
        : ZIO[Any, AwsError, zio.aws.chimesdkvoice.model.PhoneNumberOrderType] =
      AwsError.unwrapOptionField("orderType", orderType)
    def getOrderedPhoneNumbers: ZIO[Any, AwsError, List[
      zio.aws.chimesdkvoice.model.OrderedPhoneNumber.ReadOnly
    ]] = AwsError.unwrapOptionField("orderedPhoneNumbers", orderedPhoneNumbers)
    def getCreatedTimestamp: ZIO[Any, AwsError, Iso8601Timestamp] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
    def getUpdatedTimestamp: ZIO[Any, AwsError, Iso8601Timestamp] =
      AwsError.unwrapOptionField("updatedTimestamp", updatedTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.PhoneNumberOrder
  ) extends zio.aws.chimesdkvoice.model.PhoneNumberOrder.ReadOnly {
    override val phoneNumberOrderId: Optional[GuidString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.phoneNumberOrderId())
        .map(value => zio.aws.chimesdkvoice.model.primitives.GuidString(value))
    override val productType
        : Optional[zio.aws.chimesdkvoice.model.PhoneNumberProductType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.productType())
        .map(value =>
          zio.aws.chimesdkvoice.model.PhoneNumberProductType.wrap(value)
        )
    override val status
        : Optional[zio.aws.chimesdkvoice.model.PhoneNumberOrderStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.chimesdkvoice.model.PhoneNumberOrderStatus.wrap(value)
        )
    override val orderType
        : Optional[zio.aws.chimesdkvoice.model.PhoneNumberOrderType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.orderType())
        .map(value =>
          zio.aws.chimesdkvoice.model.PhoneNumberOrderType.wrap(value)
        )
    override val orderedPhoneNumbers: Optional[
      List[zio.aws.chimesdkvoice.model.OrderedPhoneNumber.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.orderedPhoneNumbers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.chimesdkvoice.model.OrderedPhoneNumber.wrap(item)
        }.toList
      )
    override val createdTimestamp: Optional[Iso8601Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdTimestamp())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.Iso8601Timestamp(value)
        )
    override val updatedTimestamp: Optional[Iso8601Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updatedTimestamp())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.Iso8601Timestamp(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.PhoneNumberOrder
  ): zio.aws.chimesdkvoice.model.PhoneNumberOrder.ReadOnly = new Wrapper(impl)
}
