package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkvoice.model.primitives.E164PhoneNumber
import scala.jdk.CollectionConverters._
final case class OrderedPhoneNumber(
    e164PhoneNumber: Optional[E164PhoneNumber] = Optional.Absent,
    status: Optional[zio.aws.chimesdkvoice.model.OrderedPhoneNumberStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.OrderedPhoneNumber = {
    import OrderedPhoneNumber.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.OrderedPhoneNumber
      .builder()
      .optionallyWith(
        e164PhoneNumber.map(value =>
          E164PhoneNumber.unwrap(value): java.lang.String
        )
      )(_.e164PhoneNumber)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.chimesdkvoice.model.OrderedPhoneNumber.ReadOnly =
    zio.aws.chimesdkvoice.model.OrderedPhoneNumber.wrap(buildAwsValue())
}
object OrderedPhoneNumber {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.OrderedPhoneNumber
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.OrderedPhoneNumber =
      zio.aws.chimesdkvoice.model.OrderedPhoneNumber(
        e164PhoneNumber.map(value => value),
        status.map(value => value)
      )
    def e164PhoneNumber: Optional[E164PhoneNumber]
    def status: Optional[zio.aws.chimesdkvoice.model.OrderedPhoneNumberStatus]
    def getE164PhoneNumber: ZIO[Any, AwsError, E164PhoneNumber] =
      AwsError.unwrapOptionField("e164PhoneNumber", e164PhoneNumber)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkvoice.model.OrderedPhoneNumberStatus
    ] = AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.OrderedPhoneNumber
  ) extends zio.aws.chimesdkvoice.model.OrderedPhoneNumber.ReadOnly {
    override val e164PhoneNumber: Optional[E164PhoneNumber] =
      zio.aws.core.internal
        .optionalFromNullable(impl.e164PhoneNumber())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.E164PhoneNumber(value)
        )
    override val status
        : Optional[zio.aws.chimesdkvoice.model.OrderedPhoneNumberStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.chimesdkvoice.model.OrderedPhoneNumberStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.OrderedPhoneNumber
  ): zio.aws.chimesdkvoice.model.OrderedPhoneNumber.ReadOnly = new Wrapper(impl)
}
