package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListVoiceConnectorsResponse(
    voiceConnectors: Optional[
      Iterable[zio.aws.chimesdkvoice.model.VoiceConnector]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceConnectorsResponse = {
    import ListVoiceConnectorsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceConnectorsResponse
      .builder()
      .optionallyWith(
        voiceConnectors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.voiceConnectors)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.ListVoiceConnectorsResponse.ReadOnly =
    zio.aws.chimesdkvoice.model.ListVoiceConnectorsResponse
      .wrap(buildAwsValue())
}
object ListVoiceConnectorsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceConnectorsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.ListVoiceConnectorsResponse =
      zio.aws.chimesdkvoice.model.ListVoiceConnectorsResponse(
        voiceConnectors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def voiceConnectors
        : Optional[List[zio.aws.chimesdkvoice.model.VoiceConnector.ReadOnly]]
    def nextToken: Optional[String]
    def getVoiceConnectors: ZIO[Any, AwsError, List[
      zio.aws.chimesdkvoice.model.VoiceConnector.ReadOnly
    ]] = AwsError.unwrapOptionField("voiceConnectors", voiceConnectors)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceConnectorsResponse
  ) extends zio.aws.chimesdkvoice.model.ListVoiceConnectorsResponse.ReadOnly {
    override val voiceConnectors
        : Optional[List[zio.aws.chimesdkvoice.model.VoiceConnector.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.voiceConnectors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chimesdkvoice.model.VoiceConnector.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceConnectorsResponse
  ): zio.aws.chimesdkvoice.model.ListVoiceConnectorsResponse.ReadOnly =
    new Wrapper(impl)
}
