package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkvoice.model.primitives.NextTokenString
import scala.jdk.CollectionConverters._
final case class ListSipMediaApplicationsResponse(
    sipMediaApplications: Optional[
      Iterable[zio.aws.chimesdkvoice.model.SipMediaApplication]
    ] = Optional.Absent,
    nextToken: Optional[NextTokenString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.ListSipMediaApplicationsResponse = {
    import ListSipMediaApplicationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.ListSipMediaApplicationsResponse
      .builder()
      .optionallyWith(
        sipMediaApplications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sipMediaApplications)
      .optionallyWith(
        nextToken.map(value => NextTokenString.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.ListSipMediaApplicationsResponse.ReadOnly =
    zio.aws.chimesdkvoice.model.ListSipMediaApplicationsResponse
      .wrap(buildAwsValue())
}
object ListSipMediaApplicationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.ListSipMediaApplicationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkvoice.model.ListSipMediaApplicationsResponse =
      zio.aws.chimesdkvoice.model.ListSipMediaApplicationsResponse(
        sipMediaApplications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def sipMediaApplications: Optional[
      List[zio.aws.chimesdkvoice.model.SipMediaApplication.ReadOnly]
    ]
    def nextToken: Optional[NextTokenString]
    def getSipMediaApplications: ZIO[Any, AwsError, List[
      zio.aws.chimesdkvoice.model.SipMediaApplication.ReadOnly
    ]] =
      AwsError.unwrapOptionField("sipMediaApplications", sipMediaApplications)
    def getNextToken: ZIO[Any, AwsError, NextTokenString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.ListSipMediaApplicationsResponse
  ) extends zio.aws.chimesdkvoice.model.ListSipMediaApplicationsResponse.ReadOnly {
    override val sipMediaApplications: Optional[
      List[zio.aws.chimesdkvoice.model.SipMediaApplication.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sipMediaApplications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.chimesdkvoice.model.SipMediaApplication.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextTokenString] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.chimesdkvoice.model.primitives.NextTokenString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.ListSipMediaApplicationsResponse
  ): zio.aws.chimesdkvoice.model.ListSipMediaApplicationsResponse.ReadOnly =
    new Wrapper(impl)
}
