package zio.aws.chimesdkvoice.model
import zio.aws.chimesdkvoice.model.primitives.{NextTokenString, ResultMax}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListSipMediaApplicationsRequest(
    maxResults: Optional[ResultMax] = Optional.Absent,
    nextToken: Optional[NextTokenString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.ListSipMediaApplicationsRequest = {
    import ListSipMediaApplicationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.ListSipMediaApplicationsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => ResultMax.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextTokenString.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.ListSipMediaApplicationsRequest.ReadOnly =
    zio.aws.chimesdkvoice.model.ListSipMediaApplicationsRequest
      .wrap(buildAwsValue())
}
object ListSipMediaApplicationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.ListSipMediaApplicationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkvoice.model.ListSipMediaApplicationsRequest =
      zio.aws.chimesdkvoice.model.ListSipMediaApplicationsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Optional[ResultMax]
    def nextToken: Optional[NextTokenString]
    def getMaxResults: ZIO[Any, AwsError, ResultMax] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextTokenString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.ListSipMediaApplicationsRequest
  ) extends zio.aws.chimesdkvoice.model.ListSipMediaApplicationsRequest.ReadOnly {
    override val maxResults: Optional[ResultMax] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.chimesdkvoice.model.primitives.ResultMax(value))
    override val nextToken: Optional[NextTokenString] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.chimesdkvoice.model.primitives.NextTokenString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.ListSipMediaApplicationsRequest
  ): zio.aws.chimesdkvoice.model.ListSipMediaApplicationsRequest.ReadOnly =
    new Wrapper(impl)
}
