package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetVoiceConnectorLoggingConfigurationResponse(
    loggingConfiguration: Optional[
      zio.aws.chimesdkvoice.model.LoggingConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorLoggingConfigurationResponse = {
    import GetVoiceConnectorLoggingConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorLoggingConfigurationResponse
      .builder()
      .optionallyWith(loggingConfiguration.map(value => value.buildAwsValue()))(
        _.loggingConfiguration
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.GetVoiceConnectorLoggingConfigurationResponse.ReadOnly =
    zio.aws.chimesdkvoice.model.GetVoiceConnectorLoggingConfigurationResponse
      .wrap(buildAwsValue())
}
object GetVoiceConnectorLoggingConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorLoggingConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkvoice.model.GetVoiceConnectorLoggingConfigurationResponse =
      zio.aws.chimesdkvoice.model.GetVoiceConnectorLoggingConfigurationResponse(
        loggingConfiguration.map(value => value.asEditable)
      )
    def loggingConfiguration
        : Optional[zio.aws.chimesdkvoice.model.LoggingConfiguration.ReadOnly]
    def getLoggingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkvoice.model.LoggingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("loggingConfiguration", loggingConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorLoggingConfigurationResponse
  ) extends zio.aws.chimesdkvoice.model.GetVoiceConnectorLoggingConfigurationResponse.ReadOnly {
    override val loggingConfiguration
        : Optional[zio.aws.chimesdkvoice.model.LoggingConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loggingConfiguration())
        .map(value =>
          zio.aws.chimesdkvoice.model.LoggingConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorLoggingConfigurationResponse
  ): zio.aws.chimesdkvoice.model.GetVoiceConnectorLoggingConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
