package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkvoice.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters._
final case class GetSipRuleRequest(sipRuleId: NonEmptyString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.GetSipRuleRequest = {
    import GetSipRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.GetSipRuleRequest
      .builder()
      .sipRuleId(NonEmptyString.unwrap(sipRuleId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.chimesdkvoice.model.GetSipRuleRequest.ReadOnly =
    zio.aws.chimesdkvoice.model.GetSipRuleRequest.wrap(buildAwsValue())
}
object GetSipRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.GetSipRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.GetSipRuleRequest =
      zio.aws.chimesdkvoice.model.GetSipRuleRequest(sipRuleId)
    def sipRuleId: NonEmptyString
    def getSipRuleId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(sipRuleId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.GetSipRuleRequest
  ) extends zio.aws.chimesdkvoice.model.GetSipRuleRequest.ReadOnly {
    override val sipRuleId: NonEmptyString =
      zio.aws.chimesdkvoice.model.primitives.NonEmptyString(impl.sipRuleId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.GetSipRuleRequest
  ): zio.aws.chimesdkvoice.model.GetSipRuleRequest.ReadOnly = new Wrapper(impl)
}
