package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkvoice.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters._
final case class GetSipMediaApplicationAlexaSkillConfigurationRequest(
    sipMediaApplicationId: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.GetSipMediaApplicationAlexaSkillConfigurationRequest = {
    import GetSipMediaApplicationAlexaSkillConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.GetSipMediaApplicationAlexaSkillConfigurationRequest
      .builder()
      .sipMediaApplicationId(
        NonEmptyString.unwrap(sipMediaApplicationId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.GetSipMediaApplicationAlexaSkillConfigurationRequest.ReadOnly =
    zio.aws.chimesdkvoice.model.GetSipMediaApplicationAlexaSkillConfigurationRequest
      .wrap(buildAwsValue())
}
object GetSipMediaApplicationAlexaSkillConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.GetSipMediaApplicationAlexaSkillConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkvoice.model.GetSipMediaApplicationAlexaSkillConfigurationRequest =
      zio.aws.chimesdkvoice.model
        .GetSipMediaApplicationAlexaSkillConfigurationRequest(
          sipMediaApplicationId
        )
    def sipMediaApplicationId: NonEmptyString
    def getSipMediaApplicationId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(sipMediaApplicationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.GetSipMediaApplicationAlexaSkillConfigurationRequest
  ) extends zio.aws.chimesdkvoice.model.GetSipMediaApplicationAlexaSkillConfigurationRequest.ReadOnly {
    override val sipMediaApplicationId: NonEmptyString =
      zio.aws.chimesdkvoice.model.primitives
        .NonEmptyString(impl.sipMediaApplicationId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.GetSipMediaApplicationAlexaSkillConfigurationRequest
  ): zio.aws.chimesdkvoice.model.GetSipMediaApplicationAlexaSkillConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
