package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkvoice.model.primitives.GuidString
import scala.jdk.CollectionConverters._
final case class GetPhoneNumberOrderRequest(phoneNumberOrderId: GuidString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.GetPhoneNumberOrderRequest = {
    import GetPhoneNumberOrderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.GetPhoneNumberOrderRequest
      .builder()
      .phoneNumberOrderId(
        GuidString.unwrap(phoneNumberOrderId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.GetPhoneNumberOrderRequest.ReadOnly =
    zio.aws.chimesdkvoice.model.GetPhoneNumberOrderRequest.wrap(buildAwsValue())
}
object GetPhoneNumberOrderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.GetPhoneNumberOrderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.GetPhoneNumberOrderRequest =
      zio.aws.chimesdkvoice.model.GetPhoneNumberOrderRequest(phoneNumberOrderId)
    def phoneNumberOrderId: GuidString
    def getPhoneNumberOrderId: ZIO[Any, Nothing, GuidString] =
      ZIO.succeed(phoneNumberOrderId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.GetPhoneNumberOrderRequest
  ) extends zio.aws.chimesdkvoice.model.GetPhoneNumberOrderRequest.ReadOnly {
    override val phoneNumberOrderId: GuidString =
      zio.aws.chimesdkvoice.model.primitives
        .GuidString(impl.phoneNumberOrderId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.GetPhoneNumberOrderRequest
  ): zio.aws.chimesdkvoice.model.GetPhoneNumberOrderRequest.ReadOnly =
    new Wrapper(impl)
}
