package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DisassociatePhoneNumbersFromVoiceConnectorGroupResponse(
    phoneNumberErrors: Optional[
      Iterable[zio.aws.chimesdkvoice.model.PhoneNumberError]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.DisassociatePhoneNumbersFromVoiceConnectorGroupResponse = {
    import DisassociatePhoneNumbersFromVoiceConnectorGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.DisassociatePhoneNumbersFromVoiceConnectorGroupResponse
      .builder()
      .optionallyWith(
        phoneNumberErrors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.phoneNumberErrors)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.DisassociatePhoneNumbersFromVoiceConnectorGroupResponse.ReadOnly =
    zio.aws.chimesdkvoice.model.DisassociatePhoneNumbersFromVoiceConnectorGroupResponse
      .wrap(buildAwsValue())
}
object DisassociatePhoneNumbersFromVoiceConnectorGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.DisassociatePhoneNumbersFromVoiceConnectorGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkvoice.model.DisassociatePhoneNumbersFromVoiceConnectorGroupResponse =
      zio.aws.chimesdkvoice.model
        .DisassociatePhoneNumbersFromVoiceConnectorGroupResponse(
          phoneNumberErrors.map(value =>
            value.map { item =>
              item.asEditable
            }
          )
        )
    def phoneNumberErrors
        : Optional[List[zio.aws.chimesdkvoice.model.PhoneNumberError.ReadOnly]]
    def getPhoneNumberErrors: ZIO[Any, AwsError, List[
      zio.aws.chimesdkvoice.model.PhoneNumberError.ReadOnly
    ]] = AwsError.unwrapOptionField("phoneNumberErrors", phoneNumberErrors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.DisassociatePhoneNumbersFromVoiceConnectorGroupResponse
  ) extends zio.aws.chimesdkvoice.model.DisassociatePhoneNumbersFromVoiceConnectorGroupResponse.ReadOnly {
    override val phoneNumberErrors: Optional[
      List[zio.aws.chimesdkvoice.model.PhoneNumberError.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.phoneNumberErrors())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.chimesdkvoice.model.PhoneNumberError.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.DisassociatePhoneNumbersFromVoiceConnectorGroupResponse
  ): zio.aws.chimesdkvoice.model.DisassociatePhoneNumbersFromVoiceConnectorGroupResponse.ReadOnly =
    new Wrapper(impl)
}
