package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkvoice.model.primitives.NonEmptyString256
import scala.jdk.CollectionConverters._
final case class DeleteVoiceProfileRequest(voiceProfileId: NonEmptyString256) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceProfileRequest = {
    import DeleteVoiceProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceProfileRequest
      .builder()
      .voiceProfileId(
        NonEmptyString256.unwrap(voiceProfileId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.DeleteVoiceProfileRequest.ReadOnly =
    zio.aws.chimesdkvoice.model.DeleteVoiceProfileRequest.wrap(buildAwsValue())
}
object DeleteVoiceProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.DeleteVoiceProfileRequest =
      zio.aws.chimesdkvoice.model.DeleteVoiceProfileRequest(voiceProfileId)
    def voiceProfileId: NonEmptyString256
    def getVoiceProfileId: ZIO[Any, Nothing, NonEmptyString256] =
      ZIO.succeed(voiceProfileId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceProfileRequest
  ) extends zio.aws.chimesdkvoice.model.DeleteVoiceProfileRequest.ReadOnly {
    override val voiceProfileId: NonEmptyString256 =
      zio.aws.chimesdkvoice.model.primitives
        .NonEmptyString256(impl.voiceProfileId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceProfileRequest
  ): zio.aws.chimesdkvoice.model.DeleteVoiceProfileRequest.ReadOnly =
    new Wrapper(impl)
}
