package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkvoice.model.primitives.NonEmptyString128
import scala.jdk.CollectionConverters._
final case class DeleteVoiceConnectorProxyRequest(
    voiceConnectorId: NonEmptyString128
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorProxyRequest = {
    import DeleteVoiceConnectorProxyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorProxyRequest
      .builder()
      .voiceConnectorId(
        NonEmptyString128.unwrap(voiceConnectorId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.DeleteVoiceConnectorProxyRequest.ReadOnly =
    zio.aws.chimesdkvoice.model.DeleteVoiceConnectorProxyRequest
      .wrap(buildAwsValue())
}
object DeleteVoiceConnectorProxyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorProxyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkvoice.model.DeleteVoiceConnectorProxyRequest =
      zio.aws.chimesdkvoice.model
        .DeleteVoiceConnectorProxyRequest(voiceConnectorId)
    def voiceConnectorId: NonEmptyString128
    def getVoiceConnectorId: ZIO[Any, Nothing, NonEmptyString128] =
      ZIO.succeed(voiceConnectorId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorProxyRequest
  ) extends zio.aws.chimesdkvoice.model.DeleteVoiceConnectorProxyRequest.ReadOnly {
    override val voiceConnectorId: NonEmptyString128 =
      zio.aws.chimesdkvoice.model.primitives
        .NonEmptyString128(impl.voiceConnectorId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorProxyRequest
  ): zio.aws.chimesdkvoice.model.DeleteVoiceConnectorProxyRequest.ReadOnly =
    new Wrapper(impl)
}
