package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkvoice.model.primitives.SensitiveNonEmptyString
import scala.jdk.CollectionConverters._
final case class DeletePhoneNumberRequest(
    phoneNumberId: SensitiveNonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.DeletePhoneNumberRequest = {
    import DeletePhoneNumberRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.DeletePhoneNumberRequest
      .builder()
      .phoneNumberId(
        SensitiveNonEmptyString.unwrap(phoneNumberId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.DeletePhoneNumberRequest.ReadOnly =
    zio.aws.chimesdkvoice.model.DeletePhoneNumberRequest.wrap(buildAwsValue())
}
object DeletePhoneNumberRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.DeletePhoneNumberRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.DeletePhoneNumberRequest =
      zio.aws.chimesdkvoice.model.DeletePhoneNumberRequest(phoneNumberId)
    def phoneNumberId: SensitiveNonEmptyString
    def getPhoneNumberId: ZIO[Any, Nothing, SensitiveNonEmptyString] =
      ZIO.succeed(phoneNumberId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.DeletePhoneNumberRequest
  ) extends zio.aws.chimesdkvoice.model.DeletePhoneNumberRequest.ReadOnly {
    override val phoneNumberId: SensitiveNonEmptyString =
      zio.aws.chimesdkvoice.model.primitives
        .SensitiveNonEmptyString(impl.phoneNumberId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.DeletePhoneNumberRequest
  ): zio.aws.chimesdkvoice.model.DeletePhoneNumberRequest.ReadOnly =
    new Wrapper(impl)
}
