package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkvoice.model.primitives.NonEmptyString256
import scala.jdk.CollectionConverters._
final case class CreateVoiceProfileRequest(
    speakerSearchTaskId: NonEmptyString256
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.CreateVoiceProfileRequest = {
    import CreateVoiceProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.CreateVoiceProfileRequest
      .builder()
      .speakerSearchTaskId(
        NonEmptyString256.unwrap(speakerSearchTaskId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.CreateVoiceProfileRequest.ReadOnly =
    zio.aws.chimesdkvoice.model.CreateVoiceProfileRequest.wrap(buildAwsValue())
}
object CreateVoiceProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.CreateVoiceProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.CreateVoiceProfileRequest =
      zio.aws.chimesdkvoice.model.CreateVoiceProfileRequest(speakerSearchTaskId)
    def speakerSearchTaskId: NonEmptyString256
    def getSpeakerSearchTaskId: ZIO[Any, Nothing, NonEmptyString256] =
      ZIO.succeed(speakerSearchTaskId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.CreateVoiceProfileRequest
  ) extends zio.aws.chimesdkvoice.model.CreateVoiceProfileRequest.ReadOnly {
    override val speakerSearchTaskId: NonEmptyString256 =
      zio.aws.chimesdkvoice.model.primitives
        .NonEmptyString256(impl.speakerSearchTaskId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.CreateVoiceProfileRequest
  ): zio.aws.chimesdkvoice.model.CreateVoiceProfileRequest.ReadOnly =
    new Wrapper(impl)
}
